/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectSignedFilesFormular;
import java.io.File;
import java.util.List;

public class ProcessSubsequentProcess
extends SubsequentProcess {
    private ProcessName processName;

    public ProcessSubsequentProcess(ProcessName process, String uID) {
        super(uID);
        this.processName = process;
    }

    public ProcessName getProcessName() {
        return this.processName;
    }

    @Override
    public void callSubsequentProcess(List<File> files) {
        ProcessI process = Document.getInstance().getProcessFactory().getProcess(this.processName);
        ProcessFormular formular = Document.getInstance().getProcessFactory().getNewProcessesFormularInstance(process);
        if (formular instanceof SelectFilesFormular) {
            SelectFilesFormular selectFilesFormular = (SelectFilesFormular)((Object)formular);
            selectFilesFormular.setSelectedFiles(files, true);
        } else if (formular instanceof SelectSignedFilesFormular) {
            SelectSignedFilesFormular selectSignedFilesFormular = (SelectSignedFilesFormular)((Object)formular);
            selectSignedFilesFormular.setSelectedFiles(files, true);
        }
        Document.getInstance().getProcessFactory().getProcessChoose().showProcess(this.processName);
    }

    @Override
    public String getProcess() {
        return this.processName.getDisplayName();
    }
}

