/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.model.ProcessFile;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessSignedFile
extends ProcessFile
implements ViewableProcessFile {
    private static final Logger LOG = LogManager.getLogger(ProcessSignedFile.class);
    private File detached;
    private boolean seen = false;
    public boolean multipleCmsSignatures = false;

    protected ProcessSignedFile() {
    }

    public ProcessSignedFile(File f) {
        super(f, null);
    }

    public ProcessSignedFile(File f, byte[] digest) {
        super(f, digest);
    }

    public ProcessSignedFile(File f, File d) {
        this(f);
        this.detached = d;
    }

    public File getDetachedFile() {
        return this.detached != null ? this.detached.getAbsoluteFile() : null;
    }

    public void setDetachedFile(File d) {
        this.detached = d;
    }

    @Override
    public boolean hasSeen() {
        return this.seen;
    }

    @Override
    public void setSeen(boolean seen) throws SignerException {
        this.seen = seen;
        if (seen) {
            if (!this.getFile().isUnchanged()) {
                LOG.info("FileDigest wird neu erzeugt, da die Datei im Dateisystem veraendert wurde. Benutzer wird informiert.");
                this.getFile().setDigest(Utils.createSHA256Hash(this.getFile()));
                throw new SignerException(ErrorCode.SHOWNFILE_CHANGED, this.getFile().getName(), null);
            }
        } else {
            this.getFile().setDigest(null);
        }
    }

    @Override
    public byte[] getDigest() {
        return this.getFile().getDigest();
    }

    @Override
    public boolean isUnchanged() {
        return this.getFile().isUnchanged();
    }
}

