/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import org.jdesktop.jdic.desktop.Message;

public class JDICSubsequentProcess
extends SubsequentProcess {
    private final JDICFunction jdicFunction;

    public JDICSubsequentProcess(JDICFunction function, String uID) {
        super(uID);
        this.jdicFunction = function;
    }

    public JDICFunction getJDICFunction() {
        return this.jdicFunction;
    }

    @Override
    public void callSubsequentProcess(List<File> files) {
        switch (this.jdicFunction) {
            case EMAIL: {
                try {
                    Message message = new Message();
                    ArrayList<String> fileNames = new ArrayList<String>();
                    for (File file : files) {
                        fileNames.add(file.getAbsolutePath());
                    }
                    message.setAttachments(fileNames);
                    Utils.sendMail(new ArrayList<String>(), Messages.getString("jdic.function.email.subject"), "", files);
                }
                catch (IOException | MessagingException e) {
                    LOG.error((Object)e, e);
                }
                break;
            }
            case OPEN: {
                for (File file : files) {
                    try {
                        Utils.openFile(file);
                    }
                    catch (IOException e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
                break;
            }
            case PRINT: {
                for (File file2 : files) {
                    try {
                        Utils.printFile(file2);
                    }
                    catch (IOException e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
                break;
            }
        }
    }

    @Override
    public String getProcess() {
        return this.jdicFunction.getDisplayName();
    }

    public static enum JDICFunction {
        EMAIL,
        OPEN,
        PRINT;


        public String getDisplayName() {
            return Messages.getString("jdic.function." + this.toString().toLowerCase() + ".displayname");
        }

        public String getName() {
            return this.toString();
        }
    }
}

