/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.Utils;
import java.io.File;

public class HashedFile
extends File {
    private static final long serialVersionUID = 5642720394948134244L;
    private byte[] originalHash;
    private boolean isPdfEncrypted = false;

    public HashedFile(File orgFile, byte[] orgFileHash) {
        super(orgFile.getAbsolutePath());
        this.originalHash = orgFileHash;
        this.isPdfEncrypted = Utils.isEncrypted(orgFile);
    }

    public HashedFile(File orgFile) {
        super(orgFile.getAbsolutePath());
        this.originalHash = Utils.createSHA256Hash(this);
        this.isPdfEncrypted = Utils.isEncrypted(orgFile);
    }

    public boolean isUnchanged() {
        byte[] fileHash = Utils.createSHA256Hash(this);
        return Utils.checkSHA(fileHash, this.originalHash);
    }

    public byte[] getDigest() {
        return this.originalHash;
    }

    public void setDigest(byte[] originalHash) {
        this.originalHash = originalHash;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isPdfEncrypted() {
        return this.isPdfEncrypted;
    }
}

