/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.GUIClientStarter;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.ActionFactory;
import de.bos_bremen.ecard.client.control.process.ProcessFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.dialog.RedundantDialog;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.ApplicationPolicy;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.FrameworkInstanceHandler;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorHandler;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.model.error.SignerErrorHandler;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.governikus.csl.ECardProgressListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Document
implements PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(Document.class);
    private static Document instance;
    private boolean saveConfig = true;
    private ProductFunctions productFunctions;
    private ProcessFactory processFactory;
    private ActionFactory actionFactory;
    private Component parent;
    public static final String PARAM_HELP_PATH = "-helpPath";
    protected List<WorkingResult> workingResultList = new ArrayList<WorkingResult>();
    private ErrorHandler errorHandler;
    private ErrorObject errorObject;
    private FrameworkInstanceHandler singleInstanceHandler;
    private FrameworkStatus.FrameworkState currentFrameworkState = FrameworkStatus.FrameworkState.none;
    private GUIClientStarter frame;
    private ApplicationPolicy applicationPolicy = ApplicationPolicy.showBeyond;
    private ProcessPolicy processPolicy = ProcessPolicy.firstStep;
    private Map<String, Object> projectObjects;
    private FontSize fontSize = FontSize.SMALL;
    protected List<ECardProgressListener> progressListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getInstance() {
        Class<Document> clazz = Document.class;
        synchronized (Document.class) {
            if (instance == null) {
                instance = new Document();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        LOG.info("FrameworkState : {} -> starting", (Object)Document.getInstance().getCurrentFrameworkState());
        this.setCurrentFrameworkState(FrameworkStatus.FrameworkState.starting);
        this.errorObject = new ErrorObject();
        this.processFactory = new ProcessFactory(null);
        LocaleChanger.getInstance().addObserver(this);
        this.progressListener = new ArrayList<ECardProgressListener>();
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public int showMessageDialog(Component parent, String key) {
        LOG.trace(key);
        return this.displayRedundantMessages(parent, key, 1, true);
    }

    public int showMessageDialogText(Component parent, String message) {
        LOG.trace(message);
        String title = Messages.getString("dialog.message.standard.title");
        return this.displayRedundantMessages(parent, "message.standard", title, message, 1, -1, true);
    }

    public int showOptionDialog(Component parent, String key, int numOptions, int messageType) {
        LOG.trace(key);
        return this.displayRedundantMessages(parent, key, numOptions, messageType, true);
    }

    public int displayRedundantMessages(Component parent, String key, int numOptions) {
        LOG.trace(key);
        return this.displayRedundantMessages(parent, key, numOptions, false);
    }

    public int displayRedundantMessages(Component parent, String key, int numOptions, boolean force) {
        LOG.trace("");
        String message = Messages.getString("dialog." + key + ".message");
        LOG.trace(message);
        String title = Messages.getString("dialog." + key + ".title");
        return this.displayRedundantMessages(parent, key, title, message, numOptions, -1, force);
    }

    public int displayRedundantMessages(Component parent, String key, int numOptions, int messageType, boolean force) {
        LOG.trace("");
        String title = Messages.getString("dialog." + key + ".title");
        String message = Messages.getString("dialog." + key + ".message");
        return this.displayRedundantMessages(parent, key, title, message, numOptions, messageType, force);
    }

    public int displayRedundantMessages(Component parent, String key, String message, int numOptions, int messageType, boolean force) {
        LOG.trace("");
        String title = Messages.getString("dialog." + key + ".title");
        return this.displayRedundantMessages(parent, key, title, message, numOptions, messageType, force);
    }

    public int displayRedundantMessages(Component parent, String key, String title, String message, int numOptions, int type, boolean force) {
        LOG.trace("");
        if (parent == null) {
            parent = this.getFrame();
        }
        return RedundantDialog.showDialog(parent, key, title, message, numOptions, type, force, this.isSaveConfig());
    }

    public void displayErrorMessages(Component parent, String dialogKey, String errorMessage, String detailMessage) {
        LOG.trace("");
        if (this.errorHandler == null) {
            return;
        }
        if (parent == null) {
            parent = this.getFrame();
        }
        this.errorHandler.displayErrorMessages(parent, dialogKey, errorMessage, detailMessage);
    }

    public void displayErrorMessages(Component parent, String dialogKey, String detailMessage) {
        LOG.trace("");
        if (this.errorHandler == null) {
            return;
        }
        if (parent == null) {
            parent = this.getFrame();
        }
        this.errorHandler.displayErrorMessages(parent, dialogKey, detailMessage);
    }

    public void setErrorHandler(ErrorHandler inErrorHandler) {
        if (this.errorHandler == null) {
            this.errorHandler = inErrorHandler;
        } else if (inErrorHandler == null) {
            this.errorHandler = null;
            LOG.info("ErrorHandler wurde zurueck gesetzt. ");
        } else {
            LOG.info("ErrorHandler war schon gesetzt. ");
        }
    }

    public void resetLastErrorObject() {
        this.errorObject = new ErrorObject();
    }

    public ErrorObject getLastReportedErrorObject() {
        return this.errorObject;
    }

    public void reportError(SignerException signerException, boolean showRedundant, Object ... inObjects) {
        if (this.getFrame() != null && this.getFrame().isSplashScreenVisible()) {
            this.getFrame().setSplashScreenVisible(false);
        }
        this.errorObject.setErrorCode(signerException != null ? signerException.getErrorCode() : ErrorCode.UNKNOWN);
        if (this.errorHandler != null) {
            this.errorObject = this.errorHandler.reportError(signerException, showRedundant, inObjects);
        } else {
            Runnable runnable = () -> {
                this.errorObject = new SignerErrorHandler(this.getFrame()).reportError(signerException, showRedundant, inObjects);
            };
            SwingUtilities.invokeLater(runnable);
        }
        if (this.getFrame() != null && !this.getFrame().isSplashScreenVisible()) {
            this.getFrame().setSplashScreenVisible(false);
        }
    }

    public void reportError(ErrorCode errorCode, boolean showRedundant, Object ... inObjects) {
        LOG.trace("");
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
        this.errorObject.setErrorCode(errorCode);
        if (this.errorHandler != null) {
            this.errorObject = this.errorHandler.reportError(errorCode, showRedundant, inObjects);
        } else {
            Runnable runnable = () -> {
                this.errorObject = new SignerErrorHandler(this.getFrame()).reportError(errorCode, showRedundant, inObjects);
            };
            SwingUtilities.invokeLater(runnable);
        }
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
    }

    public void reportError(int errorCode, boolean showRedundant, Object ... inObjects) {
        LOG.trace("");
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
        this.errorObject.setErrorCode(ErrorCode.getErrorCodeByID(errorCode));
        if (this.errorHandler != null) {
            this.errorObject = this.errorHandler.reportError(errorCode, showRedundant, inObjects);
        } else {
            Runnable runnable = () -> {
                this.errorObject = new SignerErrorHandler(this.getFrame()).reportError(errorCode, showRedundant, inObjects);
            };
            SwingUtilities.invokeLater(runnable);
        }
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
    }

    public void reportError(ErrorObject errorObj, boolean showRedundant) {
        LOG.trace("");
        this.errorObject = errorObj;
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
        if (this.errorHandler != null) {
            this.errorObject = this.errorHandler.reportError(errorObj, showRedundant);
        } else {
            Runnable runnable = () -> {
                this.errorObject = new SignerErrorHandler(this.getFrame()).reportError(errorObj, showRedundant);
            };
            SwingUtilities.invokeLater(runnable);
        }
        if (this.getFrame() != null) {
            this.getFrame().setSplashScreenVisible(false);
        }
    }

    public void setSingleInstanceHandler(FrameworkInstanceHandler singleInstanceHandler) {
        this.singleInstanceHandler = singleInstanceHandler;
    }

    public FrameworkInstanceHandler getSingleInstanceHandler() {
        return this.singleInstanceHandler;
    }

    public void setCurrentFrameworkState(FrameworkStatus.FrameworkState state) {
        this.currentFrameworkState = state;
    }

    public FrameworkStatus.FrameworkState getCurrentFrameworkState() {
        return this.currentFrameworkState;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public GUIClientStarter getFrame() {
        return this.frame;
    }

    public void setFrame(GUIClientStarter signerFrame) {
        this.frame = signerFrame;
    }

    public List<WorkingResult> getWorkingResults() {
        return this.workingResultList;
    }

    public void setWorkingResults(List<WorkingResult> workingResults) {
        this.workingResultList = workingResults;
    }

    public void setApplicationPolicy(ApplicationPolicy applicationPolicy) {
        if (!ApplicationPolicy.useDefault.equals((Object)applicationPolicy)) {
            this.applicationPolicy = applicationPolicy;
        } else {
            LOG.debug("Es bleibt weiterhin {} gesetzt", (Object)this.applicationPolicy);
        }
    }

    public ApplicationPolicy getApplicationPolicy() {
        return this.applicationPolicy;
    }

    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public boolean isSaveConfig() {
        return this.saveConfig;
    }

    public ProductFunctions getProductFunctions() {
        return this.productFunctions;
    }

    public void setProductFunctions(ProductFunctions productFunctions) {
        this.productFunctions = productFunctions;
    }

    public ProcessFactory getProcessFactory() {
        return this.processFactory;
    }

    public void setProcessFactory(ProcessFactory processFactory) {
        this.processFactory = processFactory;
    }

    public ActionFactory getActionFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = new ActionFactory(this.parent);
        }
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.actionFactory = new ActionFactory(this.parent);
    }

    public Map<String, Object> getProjectObjects() {
        if (this.projectObjects == null) {
            this.projectObjects = new HashMap<String, Object>();
        }
        return this.projectObjects;
    }

    public ProcessPolicy getProcessPolicy() {
        return this.processPolicy;
    }

    public void setProcessPolicy(ProcessPolicy processPolicy) {
        this.processPolicy = processPolicy;
    }

    public void setFontSize(FontSize fontSize) {
        this.fontSize = fontSize;
    }

    public FontSize getFontSize() {
        return this.fontSize;
    }

    public Provider getSecurityProvider() {
        return Config.getSecurityProvider();
    }

    public void addProgressListener(ECardProgressListener processListener) {
        this.progressListener.add(processListener);
    }

    public void notifyProgressListeners(ECardProgressListener.ProgressType progressType, int value) {
        if (this.progressListener != null) {
            for (ECardProgressListener listener : this.progressListener) {
                listener.notifyProgress(progressType, value);
            }
        }
    }

    public void notifyProgressListeners(ECardProgressListener.ProgressType progressType, double value) {
        if (this.progressListener != null) {
            for (ECardProgressListener listener : this.progressListener) {
                listener.notifyProgress(progressType, value);
            }
        }
    }
}

