/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.debug_mode.DebugMode;
import de.bos_bremen.debug_mode.exception.LogFileException;
import de.bos_bremen.ecard.client.GUIClientStarter;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.model.ConfigListener;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.JDICSubsequentProcess;
import de.bos_bremen.ecard.client.model.ProcessSubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcessFactory;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.server.ProxyServer;
import de.governikus.mcard.jce.sig.delegate.JCEDelegateMCardBCProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class Config {
    public static final String BOREUM_XML = "boreum.xml";
    private static final String BOREUM_IE_XML = "boreumIE.xml";
    private static final String BOREUM_WE_XML = "boreumWE.xml";
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private final DateFormat df = new SimpleDateFormat("yyyyMMdd_HHmm");
    private static Config instance;
    private final ArrayList<ConfigListener> listeners = new ArrayList();
    private ProxyServer proxyServer = new ProxyServer();
    private final Set<String> suppressedRedundantDialogs = new HashSet<String>();
    private static File configFile;
    private static Long period;
    private static Boolean usePeriod;
    private static String licenceName;
    private String protocolFile = "";
    private DebugLevel protocolLevel = DebugLevel.none;
    private XMLProperties processProperties = new XMLProperties(true);
    private Locale locale = Locale.GERMAN;
    private String configDialogSize;
    private Component parent;
    private List<SubsequentProcess> subsequentProcessList = new ArrayList<SubsequentProcess>();
    private boolean navigationInvisible = false;
    private boolean filterConfiguration = false;

    public static String getSecurityProviderName() {
        return "BC";
    }

    public static final Provider getSecurityProvider() {
        LOG.trace("");
        if (Security.getProvider("OCF") == null) {
            Security.insertProviderAt((Provider)new OCFProvider(), 1);
        }
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        }
        JCEDelegateMCardBCProvider jd = new JCEDelegateMCardBCProvider();
        BouncyCastleJsseProvider jj = new BouncyCastleJsseProvider(false, (Provider)jd);
        Security.insertProviderAt((Provider)jd, 1);
        Security.addProvider((Provider)jj);
        LOG.trace("");
        return Security.getProvider(Config.getSecurityProviderName());
    }

    private Config(Component parent, String fileName, boolean filterConfiguration) {
        LOG.trace("config file name : {}", (Object)fileName);
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        this.parent = parent;
        this.filterConfiguration = filterConfiguration;
        LOG.debug((Object)System.getProperties());
        LOG.info("config folder: {}", (Object)System.getProperty("BoreumConfigFolder", System.getProperty("user.home")));
        configFile = new File(System.getProperty("BoreumConfigFolder", System.getProperty("user.home")), fileName);
        LOG.info("config file: {}", (Object)configFile);
        if (!configFile.exists()) {
            LOG.info("config file does not exist.");
            this.subsequentProcessList = SubsequentProcessFactory.loadSubsequentProcess(new XMLProperties());
            return;
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            LOG.trace("load ... {}", (Object)configFile);
            this.load(in);
        }
        catch (IOException ex) {
            LOG.warn("could not load file. {}", (Object)configFile);
        }
        LOG.trace("done config : {}", (Object)fileName);
    }

    private Config(Component parent, String fileName) {
        LOG.trace("config file name : {}", (Object)fileName);
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        this.parent = parent;
        this.protocolFile = this.getProtocolFileFrom(new XMLProperties());
        this.subsequentProcessList = SubsequentProcessFactory.loadDefaultSubsequentProcess();
        LOG.debug((Object)System.getProperties());
        String boreumConfigFolder = System.getProperty("BoreumConfigFolder", System.getProperty("user.home"));
        LOG.info("config folder: {}", (Object)boreumConfigFolder);
        configFile = new File(boreumConfigFolder, fileName);
        LOG.info("done reset config file: {}", (Object)configFile);
    }

    public File getConfigFile() {
        LOG.trace((Object)configFile);
        return configFile;
    }

    public static Config getInstance() {
        LOG.trace("");
        if (instance == null) {
            throw new RuntimeException("Config must be init before use.");
        }
        return instance;
    }

    public static Config resetInstance() {
        LOG.info("reset : {} ", (Object)configFile.getName());
        instance = new Config(Config.instance.parent, configFile.getName());
        return instance;
    }

    public static void init(Component parent, boolean filterConfiguration) {
        LOG.trace("init Config Instance...");
        if (instance != null) {
            LOG.trace("Config Instance ist schon vorhanden : {}", (Object)instance.getConfigFile().getName());
            return;
        }
        if (Document.getInstance().getProductFunctions().enableGeneralIntegratedWS().isEditable()) {
            LOG.trace(BOREUM_IE_XML);
            instance = new Config(parent, BOREUM_IE_XML, filterConfiguration);
        } else if (!Document.getInstance().isSaveConfig()) {
            LOG.trace(BOREUM_WE_XML);
            instance = new Config(parent, BOREUM_WE_XML, filterConfiguration);
        } else {
            LOG.trace(BOREUM_XML);
            LOG.debug("try new Config : {} ", (Object)BOREUM_XML);
            instance = new Config(parent, BOREUM_XML, filterConfiguration);
        }
    }

    public static void init(Component parent, String filename) {
        LOG.trace("init : {}", (Object)filename);
        instance = new Config(parent, filename, false);
    }

    public boolean load(InputStream in) throws IOException {
        LOG.trace("try load ...");
        boolean returnValue = true;
        XMLProperties props = new XMLProperties(true);
        props.loadFromXML(in);
        LOG.trace("XML Properties von Stream geladen : {}", (Object)props);
        this.proxyServer = this.getProxyFrom(props);
        LOG.trace("proxy props : {}", (Object)this.proxyServer);
        this.checkValidationServiceFromPac(this.proxyServer, this.getValidationUrl(props));
        LOG.trace("SignerValidationProcessor: set ProxyServer beim Start.");
        SignerValidationProcessor.getInstance().setProxyServer(this.proxyServer);
        LOG.trace("ValidationProcessor ProxyServer : {}", (Object)SignerValidationProcessor.getInstance().getProxyConfiguration());
        this.protocolFile = this.getProtocolFileFrom(props);
        this.protocolLevel = this.getProtocolLevelFrom(props);
        this.setSuppressedRedundantDialogsFrom(props);
        XMLProperties tempProcessProperties = props.getPropertiesForNode("process");
        this.processProperties.addAll("", tempProcessProperties);
        this.locale = this.getUserLanguageFrom(props);
        this.configDialogSize = props.getProperty("config.dialog.size");
        Document.getInstance().setFontSize(this.getUserFontFrom(props));
        this.navigationInvisible = this.getNavigationInvisible(props);
        if (Document.getInstance().getProductFunctions().enableGeneralActionsSettingsSubsequentProcess().isVisible()) {
            this.subsequentProcessList = SubsequentProcessFactory.loadSubsequentProcess(props);
            if (SubsequentProcessFactory.createdNONEProcess()) {
                for (ProcessI process : Document.getInstance().getProcessFactory().getProcesses()) {
                    process.setSubsequentProcessUID(SubsequentProcessFactory.getNONEProcessUID());
                    this.processProperties.setProperty(process.getProcessName().getName() + "/subsequent_process_uid", SubsequentProcessFactory.getNONEProcessUID());
                }
            }
        }
        this.initDebugMode();
        LOG.trace("done load.");
        return returnValue;
    }

    public boolean checkConfigFile(InputStream in) throws IOException {
        LOG.trace("check is configfile ?...");
        boolean returnValue = false;
        XMLProperties props = new XMLProperties(true);
        props.loadFromXML(in);
        if (!Document.getInstance().isSaveConfig() && !props.getPropertiesForNode("process").isEmpty() || !props.getPropertiesForNode("protocol").isEmpty() && !props.getPropertiesForNode("process").isEmpty()) {
            returnValue = true;
        }
        LOG.trace("check is configfile? done : {}", (Object)returnValue);
        return returnValue;
    }

    public void store(File out, boolean fireConfigChangeEvent) throws IOException {
        LOG.trace("store in {} ...", (Object)out);
        try {
            if (!out.exists() && !out.createNewFile()) {
                LOG.debug("could not create file: {}", (Object)out);
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        XMLProperties props = new XMLProperties();
        props.put("Version", "10.11.1");
        LOG.trace("");
        props.addAll("proxy", this.proxyServer.getXMLProperties());
        XMLProperties protocolProperties = new XMLProperties();
        protocolProperties.setProperty("file", this.protocolFile != null ? this.protocolFile : "");
        protocolProperties.setProperty("level", this.protocolLevel != null ? this.protocolLevel.toString() : "");
        if (!this.filterConfiguration) {
            props.addAll("protocol", protocolProperties);
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> iter = this.suppressedRedundantDialogs.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next() + (iter.hasNext() ? "," : ""));
        }
        if (!this.filterConfiguration) {
            props.setProperty("suppressedRedundantDialogs", buf.toString());
        }
        props.addAll("process", this.processProperties);
        if (!this.filterConfiguration) {
            props.setProperty("user.language", this.locale.getLanguage());
            props.setProperty("user.font", Document.getInstance().getFontSize().toString());
            if (this.configDialogSize != null) {
                props.setProperty("config.dialog.size", this.configDialogSize);
            }
            props.setProperty("navigation_invisible", Boolean.toString(this.navigationInvisible));
            SubsequentProcessFactory.saveSubsequentProcess(this.subsequentProcessList, props);
        }
        props.storeToXML(out);
        if (fireConfigChangeEvent) {
            this.fireConfigChangedEvent();
        }
    }

    public void storeDefault() {
        LOG.trace("");
        this.storeDefault(true);
    }

    public void storeDefault(boolean fireConfigChangeEvent) {
        LOG.trace("");
        if (!Document.getInstance().isSaveConfig()) {
            return;
        }
        try {
            this.store(configFile, fireConfigChangeEvent);
        }
        catch (IOException e) {
            Document.getInstance().showMessageDialogText(null, Messages.getString("dialog.error.title"));
        }
    }

    public void setProcessProperties(XMLProperties p) {
        LOG.trace("XML -> Config");
        this.processProperties = p;
    }

    public XMLProperties getProcessProperties() {
        LOG.trace("");
        return this.processProperties;
    }

    public void fireConfigChangedEvent() {
        LOG.trace("");
        for (ConfigListener element : this.listeners) {
            element.configChanged();
        }
    }

    public void addListener(ConfigListener cl) {
        this.listeners.add(cl);
    }

    public void removeListener(ConfigListener cl) {
        this.listeners.remove(cl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void addSuppressedRedundantDialog(String id) {
        this.suppressedRedundantDialogs.add(id);
    }

    public void removeSuppressedElement(String id) {
        this.suppressedRedundantDialogs.remove(id);
    }

    public void removeAllSuppressedElement() {
        this.suppressedRedundantDialogs.clear();
    }

    public boolean isSuppressed(String id) {
        return this.suppressedRedundantDialogs.contains(id) || this.suppressedRedundantDialogs.contains("all");
    }

    private void setSuppressedRedundantDialogsFrom(XMLProperties props) {
        String dialogIds = props.getProperty("suppressedRedundantDialogs");
        if (dialogIds != null) {
            StringTokenizer tokens = new StringTokenizer(dialogIds, ",");
            while (tokens.hasMoreTokens()) {
                this.suppressedRedundantDialogs.add(tokens.nextToken());
            }
        }
    }

    public boolean useProxy() {
        return this.proxyServer.isValid();
    }

    public String getProtocolFile() {
        return this.protocolFile;
    }

    public void setProtocolFile(String f) {
        this.protocolFile = f;
    }

    public DebugLevel getProtocolLevel() {
        return this.protocolLevel;
    }

    public void setProtocolLevel(DebugLevel l) {
        this.protocolLevel = l;
        this.fireConfigChangedEvent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    public void setConfigDialogSize(Dimension preferredSize) {
        this.configDialogSize = preferredSize.width + "x" + preferredSize.height;
    }

    public Dimension getConfigDialogSize() {
        if (this.configDialogSize != null) {
            String[] dimensions = this.configDialogSize.split("x");
            try {
                return new Dimension(Integer.parseInt(dimensions[0]), Integer.parseInt(dimensions[1]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public List<SubsequentProcess> getSubsequentProcessList() {
        ArrayList<SubsequentProcess> returnSubsequentProcessList = new ArrayList<SubsequentProcess>();
        SubsequentProcess[] subsequentProcesses = new SubsequentProcess[5];
        ArrayList<JDICSubsequentProcess> otherSubsequentProcesses = new ArrayList<JDICSubsequentProcess>();
        ArrayList<String> moreSubsequentProcesses = new ArrayList<String>();
        for (SubsequentProcess subsequentProcess : this.subsequentProcessList) {
            if (subsequentProcess instanceof ProcessSubsequentProcess) {
                ProcessSubsequentProcess processSubsequentProcess = (ProcessSubsequentProcess)subsequentProcess;
                if (processSubsequentProcess.getProcessName().getProcessIndex() >= subsequentProcesses.length - 1) continue;
                subsequentProcesses[processSubsequentProcess.getProcessName().getProcessIndex() + 1] = subsequentProcess;
                continue;
            }
            if (subsequentProcess instanceof JDICSubsequentProcess) {
                JDICSubsequentProcess jDICSubsequentProcess = (JDICSubsequentProcess)subsequentProcess;
                otherSubsequentProcesses.add(jDICSubsequentProcess);
                continue;
            }
            moreSubsequentProcesses.add(subsequentProcess.getProcess());
        }
        for (SubsequentProcess tmpProzess : subsequentProcesses) {
            if (tmpProzess == null) continue;
            returnSubsequentProcessList.add(tmpProzess);
        }
        for (SubsequentProcess subsequentProcess : otherSubsequentProcesses) {
            if (subsequentProcess == null) continue;
            returnSubsequentProcessList.add(subsequentProcess);
        }
        Collections.sort(moreSubsequentProcesses);
        block3: for (String string : moreSubsequentProcesses) {
            for (SubsequentProcess tmpProcess : this.subsequentProcessList) {
                if (tmpProcess == null || string == null || !string.equals(tmpProcess.getProcess())) continue;
                returnSubsequentProcessList.add(tmpProcess);
                continue block3;
            }
        }
        return returnSubsequentProcessList;
    }

    public SubsequentProcess getSubsequentProcess(String uid) {
        List<SubsequentProcess> list = this.getSubsequentProcessList();
        for (SubsequentProcess subsequentProcess : list) {
            if (!subsequentProcess.getUniqueId().equals(uid)) continue;
            return subsequentProcess;
        }
        return null;
    }

    public boolean addSubsequentProces(SubsequentProcess process) {
        if (this.subsequentProcessList == null) {
            this.subsequentProcessList = new ArrayList<SubsequentProcess>();
        }
        return this.subsequentProcessList.add(process);
    }

    public boolean removeSubsequentProces(SubsequentProcess process) {
        if (this.subsequentProcessList != null) {
            return this.subsequentProcessList.remove(process);
        }
        return true;
    }

    public void setSubsequentProcessList(List<SubsequentProcess> processList) {
        this.subsequentProcessList = processList;
    }

    public void initDebugMode() {
        try {
            File generatedLogFileName = this.generatedFileName(this.getProtocolFile());
            if (generatedLogFileName == null) {
                LOG.warn("log file is null! ");
                return;
            }
            LOG.info("log file: {}", (Object)generatedLogFileName);
            if (!DebugLevel.none.equals((Object)this.getProtocolLevel())) {
                DebugMode.getInstance().setDebugLevelAndLogFile(this.getProtocolLevel(), generatedLogFileName);
            } else {
                DebugMode.getInstance().setDebugLevelAndLogFile(DebugLevel.none, generatedLogFileName);
            }
        }
        catch (LogFileException e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private File generatedFileName(String parent) {
        if (parent == null || parent.trim().isEmpty()) {
            return null;
        }
        File file = new File(parent);
        if (!file.exists() && !file.mkdirs()) {
            LOG.debug("could not create folder: {}", (Object)file);
        }
        String fileName = System.getProperty("file.separator");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        fileName = fileName.concat(dateFormat.format(new Date()));
        fileName = fileName.concat("_");
        fileName = fileName.concat(Messages.getString("application.name"));
        fileName = fileName.concat("_");
        fileName = fileName.concat("10.11.1");
        fileName = fileName.concat(".log");
        return new File(file, fileName);
    }

    public boolean isNavigationInvisible() {
        return this.navigationInvisible;
    }

    public static void setPeriod(Boolean useP, Long ... p) {
        if (p != null && p.length > 0) {
            period = p[0];
        }
        if (usePeriod == null) {
            usePeriod = useP;
        }
    }

    public Long getPeriod() {
        return period;
    }

    public Boolean isUsePeriod() {
        return usePeriod;
    }

    public String formatTimeDate(Date date) {
        return this.df.format(date);
    }

    public static void setLicenceName(String nodeValue) {
        licenceName = nodeValue;
    }

    public static String getLicenceName() {
        return licenceName;
    }

    public boolean isFilterConfiguration() {
        return this.filterConfiguration;
    }

    public static String getComponentVersion() {
        return "10.11.1";
    }

    public static String getComponentName() {
        return "Governikus DATA Boreum (Framework)";
    }

    public void setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        LOG.trace("ValidationProcessor : ProxyServer : {}", (Object)proxyServer);
        SignerValidationProcessor.getInstance().setProxyServer(proxyServer);
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    private ProxyServer getProxyFrom(XMLProperties props) {
        LOG.info("XML root/proxy/ ...");
        LOG.trace("ProxyServer vorher : {}", (Object)this.proxyServer);
        XMLProperties proxyProperties = props.getPropertiesForNode("proxy");
        LOG.debug("XML root/proxy/ : {}", (Object)proxyProperties);
        ProxyServer privateProxyServer = new ProxyServer();
        privateProxyServer.setHost(proxyProperties.getProperty("host", ""));
        privateProxyServer.setPort(proxyProperties.getProperty("port", ""));
        privateProxyServer.setUsername(proxyProperties.getProperty("user", ""));
        privateProxyServer.setPasswordFromConfig(proxyProperties.getProperty("password", ""));
        privateProxyServer.setNoProxyHost(proxyProperties.getProperty("nonProxyHosts", ""));
        privateProxyServer.setAutoConfigUrl(proxyProperties.getProperty("autoConfigUrl", ""));
        LOG.info("ProxyServer <- XML root/proxy/ : {}", (Object)privateProxyServer);
        return privateProxyServer;
    }

    private String getValidationUrl(XMLProperties props) {
        String validationUrl = null;
        try {
            validationUrl = props.getPropertiesForNode("process").getPropertiesForNode("verify").getPropertiesForNode("verificationserver").getProperty("url");
            LOG.info("XML root/process/verify/verificationserver/url : {}", (Object)validationUrl);
        }
        catch (NullPointerException npe) {
            LOG.error("XML root/process/verify/verificationserver/url : {}", validationUrl);
        }
        return validationUrl;
    }

    private void checkValidationServiceFromPac(ProxyServer privateProxyServer, String validationUrl) {
        LOG.info("");
        if (validationUrl != null && !validationUrl.isEmpty()) {
            LOG.info("");
            LOG.debug("search proxy for validation url in pac ... : {} ", (Object)validationUrl);
            String error = privateProxyServer.evalAutoConfigUrl(validationUrl);
            if (error != null && this.parent != null) {
                LOG.error("validation-url: {}", (Object)error);
                ((GUIClientStarter)this.parent).setSplashScreenVisible(false);
                LOG.debug("show error : dialog.error.pac.eval.message");
                ErrorDialog.showDialog(null, "error.pac", Messages.getString("dialog.error.pac.eval.message"), error);
                ((GUIClientStarter)this.parent).setSplashScreenVisible(true);
            } else {
                LOG.info("proxyServer.evalAutoConfigUrl : OK.");
            }
        } else if (this.parent != null) {
            LOG.info("");
            ((GUIClientStarter)this.parent).setSplashScreenVisible(false);
            LOG.debug("Einstellungen/Validierung/Validierungsdienst ist nicht konfiguriert.");
            ((GUIClientStarter)this.parent).setSplashScreenVisible(true);
        }
    }

    private Locale getUserLanguageFrom(XMLProperties props) {
        Locale[] availableLocales;
        String userLanguage = props.getProperty("user.language", Locale.GERMAN.getLanguage());
        LOG.info("root/user.language : '{}'", (Object)userLanguage);
        Locale userLocale = new Locale(userLanguage);
        for (Locale availablelocale : availableLocales = Locale.getAvailableLocales()) {
            if (!availablelocale.equals(userLocale) || !this.isLocaleInAppAvailable(userLocale)) continue;
            return userLocale;
        }
        return Locale.GERMAN;
    }

    private boolean isLocaleInAppAvailable(Locale userLocale) {
        return Locale.GERMAN.equals(userLocale) || Locale.ENGLISH.equals(userLocale);
    }

    private FontSize getUserFontFrom(XMLProperties props) {
        String property = props.getProperty("user.font", "SMALL");
        if (property == null || property.isEmpty()) {
            return FontSize.SMALL;
        }
        return FontSize.valueOf(property);
    }

    private String getProtocolFileFrom(XMLProperties props) {
        LOG.trace("");
        XMLProperties protocolProperties = props.getPropertiesForNode("protocol");
        LOG.info("protocol : '{}'", (Object)protocolProperties);
        Object protFile = protocolProperties.getProperty("file");
        if (protFile == null || ((String)protFile).isEmpty() || ((String)protFile).contains("@LOG_PATH@")) {
            String protocolDir = System.getProperty("java.io.tmpdir");
            protFile = protocolDir.replace("\\", "/") + "Governikus KG/";
            LOG.info("default protocol/file: '{}'", protFile);
        } else {
            LOG.info("config protocol/file: '{}'", protFile);
        }
        return protFile;
    }

    private DebugLevel getProtocolLevelFrom(XMLProperties props) {
        DebugLevel protLevel;
        LOG.trace("");
        XMLProperties protocolProperties = props.getPropertiesForNode("protocol");
        LOG.info("protocol : '{}'", (Object)protocolProperties);
        String debugLevel = protocolProperties.getProperty("level", "none");
        if (debugLevel == null || debugLevel.isEmpty()) {
            protLevel = DebugLevel.none;
            LOG.info("default protocol/level: {}", (Object)protLevel);
        } else {
            protLevel = DebugLevel.valueOf((String)debugLevel);
            LOG.info("config protocol/level: '{}'", (Object)protLevel);
        }
        return protLevel;
    }

    private boolean getNavigationInvisible(XMLProperties props) {
        String privateNavigationInvisible = props.getProperty("navigation_invisible", "false");
        if (privateNavigationInvisible == null || privateNavigationInvisible.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(privateNavigationInvisible);
    }

    static {
        period = null;
        usePeriod = null;
    }
}

