/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.formular.FormularChangedEvent;

public class Block {
    private static final int MAX_BLOCK_REQUEST_TIME = 1000;
    int blockRequestCounter = 0;
    long lastBlockRequest = -1L;
    boolean notifyRequest = false;
    FormularChangedEvent changeEvent;

    public FormularChangedEvent getEvent() {
        return this.changeEvent;
    }

    public void addBlockRequest() {
        if (this.getBlockRequestCount() == 0) {
            this.changeEvent = new FormularChangedEvent();
        }
        this.blockRequestCounter = this.getBlockRequestCount() + 1;
        this.lastBlockRequest = System.currentTimeMillis();
    }

    private int getBlockRequestCount() {
        if (System.currentTimeMillis() - 1000L > this.lastBlockRequest) {
            this.blockRequestCounter = 0;
        }
        return this.blockRequestCounter;
    }

    public boolean removeBlockRequest() {
        int newCounter = this.getBlockRequestCount() - 1;
        this.blockRequestCounter = newCounter >= 0 ? newCounter : 0;
        if (this.blockRequestCounter == 0) {
            boolean result = this.notifyRequest;
            this.notifyRequest = false;
            return result;
        }
        return false;
    }

    public boolean addNotifyRequest(StepFactory.StepName stepName) {
        if (this.blockRequestCounter <= 0) {
            this.changeEvent = new FormularChangedEvent();
            this.changeEvent.addChangedFormular(stepName);
            return true;
        }
        this.changeEvent.addChangedFormular(stepName);
        this.notifyRequest = true;
        return false;
    }
}

