/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.textfields;

import de.bos_bremen.ecard.client.Messages;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TargetFolderTextField
extends JTextField {
    private static final long serialVersionUID = 1L;

    public TargetFolderTextField() {
        this.init();
    }

    public TargetFolderTextField(int col) {
        super(col);
        this.init();
    }

    private void init() {
        this.setEditable(false);
        this.getDocument().addDocumentListener(new TargetFolderDocumentListener());
    }

    public void check() {
        boolean exists = new File(this.getText()).exists();
        this.setForeground(exists ? new JTextField().getForeground() : UIManager.getColor("TextField.error.foreground"));
        this.setBackground(exists ? new JTextField().getBackground() : UIManager.getColor("TextField.error.background"));
        this.setToolTipText(exists ? null : Messages.getString("targetfoldertextfield.notexists.tooltip"));
    }

    private class TargetFolderDocumentListener
    implements DocumentListener {
        private TargetFolderDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            TargetFolderTextField.this.check();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            TargetFolderTextField.this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            TargetFolderTextField.this.check();
        }
    }
}

