/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.textfields;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class MaximumLengthTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private int maximumLength;

    public MaximumLengthTextField(int maxLength) {
        this.maximumLength = maxLength;
        this.setInputVerifier(new MaximumLengthVerifier());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField tf = (JTextField)e.getSource();
                MaximumLengthTextField.this.getInputVerifier().verify(tf);
            }
        });
    }

    private class MaximumLengthVerifier
    extends InputVerifier {
        private MaximumLengthVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean erg = true;
            JTextField tf = (JTextField)input;
            String text = tf.getText();
            if (text.length() > MaximumLengthTextField.this.maximumLength) {
                erg = false;
            }
            if (!erg) {
                tf.setBackground(UIManager.getColor("TextField.error.background"));
                tf.setForeground(UIManager.getColor("TextField.error.foreground"));
            } else {
                tf.setBackground(UIManager.getColor("TextField.background"));
                tf.setForeground(UIManager.getColor("TextField.foreground"));
            }
            tf.setCaretColor(tf.getForeground());
            return erg;
        }
    }
}

