/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.textfields;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class IntegerTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntegerTextField() {
        this.setInputVerifier(new IntegerInputVerifier());
    }

    public IntegerTextField(int min, int max) {
        this.min = min;
        this.max = max;
        this.setHorizontalAlignment(11);
        this.setInputVerifier(new IntegerInputVerifier());
    }

    private class IntegerInputVerifier
    extends InputVerifier {
        private IntegerInputVerifier() {
        }

        @Override
        public boolean verify(JComponent component) {
            boolean erg = true;
            JTextField tf = (JTextField)component;
            String text = tf.getText();
            int value = 0;
            try {
                value = Integer.parseInt(text);
            }
            catch (Exception ex) {
                erg = false;
            }
            if (value < IntegerTextField.this.min || value > IntegerTextField.this.max) {
                erg = false;
            }
            if (!erg) {
                tf.setBackground(UIManager.getColor("TextField.error.background"));
                tf.setForeground(UIManager.getColor("TextField.error.foreground"));
            } else {
                tf.setBackground(new JTextField().getBackground());
                tf.setForeground(new JTextField().getForeground());
            }
            return erg;
        }
    }
}

