/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.textfields;

import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URL;
import javax.accessibility.AccessibleContext;
import javax.swing.JEditorPane;

public class AccessibleJEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    CurvedBorder focusCurvedBorder = CurvedBorder.createFocused();

    public AccessibleJEditorPane() {
        this.initGUI();
    }

    private void initGUI() {
        this.setFocusable(true);
        this.setEditable(false);
        this.focusCurvedBorder.setLineWidth(2);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccessibleJEditorPane.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AccessibleJEditorPane.this.repaint();
            }
        });
    }

    private void setAccessiableText() {
        String textHtml = this.getText();
        AccessibleJEditorPane.setAccessibleContext(textHtml, this.getAccessibleContext());
    }

    public AccessibleJEditorPane(String type, String text) {
        super(type, text);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJEditorPane(String url) throws IOException {
        super(url);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.initGUI();
        this.setAccessiableText();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setAccessiableText();
    }

    public static void setAccessibleContext(String textHtml, AccessibleContext accessibleContext) {
        if (textHtml == null) {
            return;
        }
        String header = "";
        if (((String)textHtml).indexOf("<h1>") != -1 && ((String)textHtml).indexOf("</h1>") != -1) {
            header = ((String)textHtml).substring(((String)textHtml).indexOf("<h1>") + 4, ((String)textHtml).indexOf("</h1>"));
            textHtml = ((String)textHtml).substring(0, ((String)textHtml).indexOf("<h1>")) + ((String)textHtml).substring(((String)textHtml).indexOf("</h1>"));
        }
        accessibleContext.setAccessibleName(header);
        accessibleContext.setAccessibleDescription((String)textHtml);
    }

    public static String removeHTMLTAG(String textHtml, String string) {
        if (textHtml == null) {
            return null;
        }
        textHtml = textHtml.replace(new StringBuilder("<" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("</" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("<" + string + "/>"), new StringBuilder(""));
        return textHtml;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.hasFocus()) {
            this.focusCurvedBorder.paintBorder(this, g, 0, 0, this.getSize().width, this.getSize().height);
        }
        super.paintComponent(g);
    }
}

