/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.workingresult;

import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.step.WorkingStepView;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.governikus.csl.uom.Response;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class WorkingResultTableMouseListener
extends MouseAdapter {
    protected WorkingStepView view;
    protected boolean shown;
    private static final int DATEI_COLUMN = 0;
    private static final int RESULT_COLUMN = 4;

    public WorkingResultTableMouseListener(WorkingStepView v) {
        this.view = v;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof JTable)) {
            return;
        }
        JTable table = (JTable)object;
        TableModel tableModel = table.getModel();
        if (!(tableModel instanceof DefaultTableModel)) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)tableModel;
        ViewFilesAction viewFilesAction = null;
        int column = table.columnAtPoint(e.getPoint());
        int row = table.rowAtPoint(e.getPoint());
        WorkingResult result = ((WorkingResultTableModelI)((Object)defaultTableModel)).getWorkingResultAt(row);
        int clicks = e.getClickCount();
        ProcessName processName = this.view.getWorkingStep().getParent().getProcessName();
        if (e.isMetaDown()) {
            JPopupMenu popUpMenu = Document.getInstance().getProcessFactory().getProcess(processName).getPopUpMenu(table, result.getSourceFile());
            if (popUpMenu != null) {
                table.getSelectionModel().setSelectionInterval(row, row);
                popUpMenu.show(table, e.getPoint().x, e.getPoint().y);
            }
        } else {
            Class<?> columnClass = table.getColumnClass(column);
            block0 : switch (clicks) {
                case 1: {
                    if (!columnClass.equals(ViewFilesAction.class)) break;
                    viewFilesAction = (ViewFilesAction)table.getValueAt(row, column);
                    break;
                }
                case 2: {
                    switch (column) {
                        case 0: {
                            if (!columnClass.equals(File.class) || !Document.getInstance().getProcessFactory().getProcess(processName).canOpenProcessFile()) break block0;
                            viewFilesAction = new ViewFilesAction(result.getProcessFile());
                            break block0;
                        }
                        case 4: {
                            if (!columnClass.equals(List.class) || !Document.getInstance().getProcessFactory().getProcess(processName).canOpenResultFile()) break block0;
                            ArrayList<ViewableProcessFile> pfsList = new ArrayList<ViewableProcessFile>();
                            if (processName.getName().toLowerCase().indexOf("sign") != -1) {
                                if (result.getResult().size() == 1) {
                                    pfsList.add(new ProcessFileSeen(result.getResult().get(0)));
                                } else {
                                    pfsList.add(new ProcessSignedFile(result.getResult().get(0), result.getResult().get(1)));
                                }
                            } else {
                                for (File file : result.getResult()) {
                                    pfsList.add(new ProcessFileSeen(file));
                                }
                            }
                            viewFilesAction = new ViewFilesAction(pfsList);
                            viewFilesAction.setValidateResponse((Response<?>)result.getValidateResponse());
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (viewFilesAction == null) {
            return;
        }
        this.shown = this.showFiles(viewFilesAction);
        if (this.shown && column != 4 && column != 5) {
            this.view.refreshTable(row);
        }
    }

    protected boolean showFiles(ViewFilesAction viewfiles) {
        Document.getInstance().getActionFactory().createShowFileAction(viewfiles).actionPerformed(null);
        return viewfiles.isShowSuccess();
    }
}

