/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.workingresult;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableModelI;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class WorkingResultTableModel
extends DefaultTableModel
implements WorkingResultTableModelI {
    private static final long serialVersionUID = 1L;
    private int dateiColumn = 0;
    private int dateiSeenColumn = 1;
    private int viewDateiColumn = 2;
    private int statusColumn = 3;
    private int resultColumn = 4;
    private int viewResultColumn = 5;
    private String[] columns;

    public WorkingResultTableModel(ProcessI process) {
        this.createColumns(process);
        this.setColumnIdentifiers(this.columns);
    }

    private void createColumns(ProcessI process) {
        if (!process.canOpenProcessFile()) {
            this.columns = new String[4];
            this.dateiColumn = 0;
            this.dateiSeenColumn = -1;
            this.viewDateiColumn = -1;
            this.statusColumn = 1;
            this.resultColumn = 2;
            this.viewResultColumn = 3;
        } else {
            this.columns = process.canOpenResultFile() ? new String[6] : new String[5];
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String header = Messages.getString("view.step.workingstep." + process.getProcessName().getName() + ".list.header.text" + i);
            this.columns[i] = header.startsWith("!") ? "" : header;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.dateiColumn) {
            return File.class;
        }
        if (columnIndex == this.dateiSeenColumn) {
            return Boolean.class;
        }
        if (columnIndex == this.viewDateiColumn) {
            return ViewFilesAction.class;
        }
        if (columnIndex == this.statusColumn) {
            return WorkingResult.Status.class;
        }
        if (columnIndex == this.resultColumn) {
            return List.class;
        }
        if (columnIndex == this.viewResultColumn) {
            return ViewFilesAction.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int row, int column) {
        WorkingResult workingResult = this.getWorkingResultAt(row);
        if (workingResult == null) {
            return "";
        }
        if (column == this.dateiColumn) {
            if (workingResult.isZipped()) {
                return "";
            }
            ViewableProcessFile viewableProcessFile = workingResult.getProcessFile();
            if (viewableProcessFile instanceof ProcessSignedFile) {
                ProcessSignedFile psf = (ProcessSignedFile)viewableProcessFile;
                if (psf.multipleCmsSignatures) {
                    return psf.getDetachedFile() != null ? psf.getDetachedFile() : "";
                }
            }
            return workingResult.getSourceFile() != null ? workingResult.getSourceFile() : "";
        }
        if (column == this.dateiSeenColumn) {
            return workingResult.getProcessFile() != null && workingResult.getProcessFile().hasSeen();
        }
        if (column == this.viewDateiColumn) {
            return new ViewFilesAction(workingResult.getProcessFile());
        }
        if (column == this.statusColumn) {
            return workingResult.getCurrentState();
        }
        if (column == this.resultColumn) {
            return workingResult.getResult();
        }
        if (column == this.viewResultColumn) {
            ArrayList<ViewableProcessFile> pfsList = new ArrayList<ViewableProcessFile>();
            if (workingResult.getResult() != null && !workingResult.getResult().isEmpty() && workingResult.getResult().get(0) != null) {
                pfsList.add(new ProcessFileSeen(workingResult.getResult().get(0)));
            }
            return new ViewFilesAction(pfsList);
        }
        return super.getValueAt(row, column);
    }

    @Override
    public WorkingResult getWorkingResultAt(int row) {
        try {
            Object obj = super.getValueAt(row, 0);
            if (obj instanceof WorkingResult) {
                WorkingResult workingResult = (WorkingResult)obj;
                return workingResult;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.getWorkingResultAt(row) != null) {
            WorkingResult workingResult;
            if (this.getWorkingResultAt(row).isZipped()) {
                return false;
            }
            if (column == this.viewDateiColumn) {
                return this.getWorkingResultAt(row).getProcessFile() != null;
            }
            if (column == this.viewResultColumn && ((workingResult = this.getWorkingResultAt(row)).getCurrentState().equals((Object)WorkingResult.Status.FINISHED) || workingResult.getCurrentState().equals((Object)WorkingResult.Status.ZIPPED) || workingResult.getCurrentState().equals((Object)WorkingResult.Status.UNZIPPED))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDataVector(WorkingResult[] dataVector) {
        Object[][] data = new Object[dataVector.length][1];
        for (int i = 0; i < dataVector.length; ++i) {
            data[i][0] = dataVector[i];
        }
        super.setDataVector(data, this.columns);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        super.setValueAt(value, row, column);
    }
}

