/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.workingresult;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.dialog.RedundantDialog;
import de.bos_bremen.ecard.client.gui.view.component.table.JTableWithFTKeys;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.BooleanSeenTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.ProcessFileTableHeaderRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.StatusTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.StringTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.TableFileRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.ViewFilesActionCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.AccessibleTableSelectionListener;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableModel;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableModelI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class WorkingResultTable
extends JTableWithFTKeys
implements WorkingResultTableI {
    private static final long serialVersionUID = -856161425475852968L;
    private final transient WorkingResultTableModelI model;
    private final transient ProcessI process;
    private transient AccessibleTableSelectionListener accessibleTableSelectionListener;

    public WorkingResultTable(ProcessI process) {
        this.process = process;
        this.model = new WorkingResultTableModel(process);
        super.setModel(this.model);
        this.setSelectionMode(0);
        this.setDefaultRenderer(File.class, new TableFileRenderer());
        this.setDefaultRenderer(List.class, new TableFileRenderer());
        this.setDefaultRenderer(String.class, new StringTableCellRenderer());
        this.setDefaultRenderer(WorkingResult.Status.class, new StatusTableCellRenderer());
        this.setDefaultRenderer(ViewFilesAction.class, new ViewFilesActionCellRenderer());
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanSeenTableCellRenderer());
        this.addMouseListener(this.createMouseAdapter());
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new ProcessFileTableHeaderRenderer());
        header.setReorderingAllowed(false);
        header.setResizingAllowed(true);
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.accessibleTableSelectionListener = new AccessibleTableSelectionListener(this);
        this.getSelectionModel().addListSelectionListener(this.accessibleTableSelectionListener);
        this.setFocusable(true);
        this.setCellSelectionEnabled(true);
    }

    @Override
    public void setColumnWidth() {
        if (this.process.canOpenProcessFile()) {
            this.getColumnModel().getColumn(1).setMaxWidth(28);
            this.getColumnModel().getColumn(1).setMinWidth(20);
            this.getColumnModel().getColumn(2).setMaxWidth(28);
            this.getColumnModel().getColumn(2).setMinWidth(20);
            this.getColumnModel().getColumn(3).setMaxWidth(90);
            this.getColumnModel().getColumn(3).setMinWidth(60);
            if (this.process.canOpenResultFile()) {
                this.getColumnModel().getColumn(5).setMaxWidth(28);
                this.getColumnModel().getColumn(5).setMinWidth(20);
            }
        } else {
            this.getColumnModel().getColumn(1).setMaxWidth(90);
            this.getColumnModel().getColumn(1).setMinWidth(60);
            this.getColumnModel().getColumn(3).setMaxWidth(28);
            this.getColumnModel().getColumn(3).setMinWidth(20);
        }
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        super.tableChanged(arg0);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setOrderedFocusTraversalPolicy(Vector<Component> order) {
        for (int row = 0; row < this.getModel().getRowCount(); ++row) {
            for (int column = 0; column < this.getModel().getColumnCount(); ++column) {
                TableCellRenderer cellRenderer = this.getCellRenderer(row, column);
                order.add((Component)((Object)cellRenderer));
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        super.tableChanged(new TableModelEvent(this.getModel()));
        this.getSelectionModel().setLeadSelectionIndex(0);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isSelected;
                if (e == null) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    return;
                }
                if (!this.isOnIcon(e.getPoint())) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof WorkingResultTable)) {
                    return;
                }
                WorkingResultTable table = (WorkingResultTable)object;
                int row = table.rowAtPoint(e.getPoint());
                Object rowValue = table.getValueAt(row, 0);
                if (!(rowValue instanceof File)) {
                    return;
                }
                File file = (File)rowValue;
                TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(0));
                if (!(renderer instanceof TableFileRenderer)) {
                    return;
                }
                boolean hasFocus = isSelected = true;
                TableFileRenderer fileRenderer = (TableFileRenderer)renderer.getTableCellRendererComponent(table, file, isSelected, hasFocus, row, 0);
                int paneOption = fileRenderer.getPaneOption();
                if (paneOption == 1) {
                    return;
                }
                String optionPaneTitle = paneOption == 2 ? Messages.getString("dialog.optionPane.warning") : Messages.getString("dialog.optionPane.error");
                RedundantDialog.showSimpleOneOptionDialog(fileRenderer.getParent(), optionPaneTitle, fileRenderer.getToolTipText(), paneOption);
            }

            private boolean isOnIcon(Point point) {
                int iconBreite = 24;
                int x = (int)point.getX();
                return 0 <= x && x <= iconBreite;
            }
        };
    }
}

