/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.workingresult;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class AccessibleTableSelectionListener
implements ListSelectionListener {
    JTable innerTable;

    public AccessibleTableSelectionListener(JTable table) {
        this.innerTable = table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (this.innerTable.getRowCount() > 0 && !lsm.isSelectionEmpty()) {
            this.setAccessibleNameForSelectedCell(this.innerTable);
        }
    }

    private void setAccessibleNameForSelectedCell(JTable table) {
        int selectedRow = table.getSelectedRow();
        for (int selectedCol = 0; selectedCol < table.getColumnCount(); ++selectedCol) {
            JComponent jComp;
            if (selectedRow < 0 || selectedCol < 0) continue;
            String selectedCellValue = table.getValueAt(selectedRow, selectedCol) == null ? " " : table.getValueAt(selectedRow, selectedCol).toString();
            TableCellRenderer renderer = table.getCellRenderer(selectedRow, selectedCol);
            Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(selectedRow, selectedCol), true, true, selectedRow, selectedCol);
            selectedCellValue = null;
            if (table.getValueAt(selectedRow, selectedCol) instanceof String) {
                selectedCellValue = table.getValueAt(selectedRow, selectedCol).toString();
            } else if (comp instanceof JComponent && this.isTooltipAvailable(jComp = (JComponent)comp)) {
                selectedCellValue = jComp.getToolTipText();
            }
            if (selectedCellValue != null) continue;
            selectedCellValue = table.getValueAt(selectedRow, selectedCol) == null ? " " : table.getValueAt(selectedRow, selectedCol).toString();
        }
    }

    private boolean isTooltipAvailable(JComponent jComp) {
        return jComp.getToolTipText() != null && !jComp.getToolTipText().equals("");
    }
}

