/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.renderer;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.view.component.table.ViewKeyProviderAction;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class ViewFilesActionCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.getColumnCount() > column && table.getRowCount() > row) {
            if (value instanceof ViewFilesAction || value instanceof ViewKeyProviderAction) {
                this.setEnabled(table.isCellEditable(row, column));
                this.setHorizontalAlignment(0);
                this.setText(null);
                int iconHeight = table.getRowHeight() - 2;
                ImageIcon icon = IconScalingUtils.createMultiResIcon("table.viewfile.icon", iconHeight, iconHeight);
                ImageIcon rolloverIcon = IconScalingUtils.createMultiResIcon("table.viewfile.rollover.icon", iconHeight, iconHeight);
                this.setDisabledIcon(IconScalingUtils.dimMultiResIcon(icon));
                if (isSelected && hasFocus) {
                    this.setIcon(rolloverIcon == null ? icon : rolloverIcon);
                } else {
                    this.setIcon(icon);
                }
                String message = Messages.getString("table.viewfile.tooltip");
                Object filename = "";
                if (value instanceof ViewFilesAction) {
                    ViewFilesAction viewFilesAction = (ViewFilesAction)value;
                    List<ViewableProcessFile> files = viewFilesAction.getFiles();
                    for (ViewableProcessFile viewableProcessFile : files) {
                        filename = (String)filename + (String)(viewableProcessFile != null && viewableProcessFile.getFile() != null ? viewableProcessFile.getFile().getName() + " " : "");
                    }
                    if (files.isEmpty()) {
                        filename = null;
                    }
                }
                this.setToolTipText(filename == null ? Messages.getString("table.viewfile.nofile.tooltip") : MessageFormat.format(message, filename));
            } else {
                this.setIcon(null);
            }
        } else {
            this.setIcon(null);
            this.setText("");
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

