/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.renderer;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.PropertyHashedFile;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.filechooser.FileSystemView;

public class TableFileRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon warnIcon = null;
    private ImageIcon errorIcon = null;
    private ImageIcon errorRolloverIcon = null;
    private ImageIcon okIcon = null;
    private ImageIcon okRolloverIcon = null;
    private int paneOption = 1;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(null);
        this.setIcon(null);
        if (row >= table.getRowCount() && column >= table.getColumnCount()) {
            return new JLabel(value == null ? "" : value.toString());
        }
        this.createAllIcons(table.getRowHeight() - 2);
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        int fontWidth = JComponentUtils.getFontWidth(this);
        int maxChars = columnWidth / fontWidth;
        Color tableForeground = null;
        if (value instanceof File) {
            tableForeground = this.renderFileCell(value, column, maxChars, tableForeground, isSelected, hasFocus);
        } else if (value instanceof List) {
            this.renderListCell(value, maxChars, isSelected, hasFocus);
        }
        Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (tableForeground != null) {
            this.setForeground(isSelected && hasFocus ? Color.WHITE : tableForeground);
            this.setBackground(isSelected && hasFocus ? tableForeground : this.getBackground());
        }
        return tableCellRendererComponent;
    }

    private void renderListCell(Object value, int maxChars, boolean isSelected, boolean hasFocus) {
        StringBuilder result = new StringBuilder();
        StringBuilder tooltiptext = new StringBuilder();
        ImageIcon icon = null;
        ImageIcon rolloverIcon = null;
        List fileList = (List)value;
        for (int i = fileList.size() - 1; i >= 0; --i) {
            Object absolutePath = ((File)fileList.get(i)).getAbsolutePath();
            Object e = fileList.get(i);
            if (e instanceof PropertyHashedFile) {
                PropertyHashedFile file = (PropertyHashedFile)e;
                switch (file.getHashedFileStatus()) {
                    case RED: {
                        icon = this.errorIcon;
                        rolloverIcon = this.errorRolloverIcon;
                        break;
                    }
                    case YELLOW: {
                        icon = this.warnIcon;
                        rolloverIcon = this.warnIcon;
                        break;
                    }
                    case GREEN: {
                        icon = this.okIcon;
                        rolloverIcon = this.okRolloverIcon;
                        break;
                    }
                }
                this.setIcon(isSelected && hasFocus ? rolloverIcon : icon);
            }
            if (((File)fileList.get(0)).isDirectory()) {
                absolutePath = (String)absolutePath + File.separator;
            }
            result.append((String)absolutePath);
            tooltiptext.append((String)absolutePath);
            if (i == 0) continue;
            result.append(" | ");
            tooltiptext.append("\n");
        }
        if (fileList.isEmpty()) {
            result.append(" -- ");
            tooltiptext.append(Messages.getString("table.file.nofile.tooltip"));
        }
        this.setToolTipText(MultiLineTooltips.wrapToolTip(tooltiptext.toString(), 80));
        this.setText(JComponentUtils.cutString(result.toString(), maxChars, JComponentUtils.CutMode.MODE_MIDDLE));
        this.getAccessibleContext().setAccessibleDescription(tooltiptext.toString());
    }

    private Color renderFileCell(Object value, int column, int maxChars, Color tableForeground, boolean isSelected, boolean hasFocus) {
        File file = (File)value;
        this.setToolTipText(null);
        boolean isEncryptedInSignProcess = false;
        boolean isEncryptedInValidateProcess = false;
        if (value instanceof HashedFile) {
            HashedFile hashedFile = (HashedFile)value;
            isEncryptedInSignProcess = this.isEncryptedInSignProcess(hashedFile.isPdfEncrypted());
            isEncryptedInValidateProcess = this.isEncryptedInValidateProcess(hashedFile.isPdfEncrypted());
        }
        if (this.mySetSystemIcon(file, isEncryptedInSignProcess, isEncryptedInValidateProcess)) {
            this.setSystemIcon(file);
        } else {
            String errorMessage;
            tableForeground = SignerTheme.COLOR_RED;
            this.setIcon(isSelected && hasFocus ? this.errorRolloverIcon : this.errorIcon);
            this.paneOption = 0;
            if (!file.exists()) {
                errorMessage = ErrorCode.FILE_NOT_FOUND.getDescription();
            } else if (file.isFile() && file.length() == 0L) {
                errorMessage = ErrorCode.FILE_IS_EMPTY.getDescription();
            } else if (isEncryptedInSignProcess) {
                errorMessage = ErrorCode.PDF_ENCRYPTED.getDescription();
                this.setIcon(this.warnIcon);
                this.paneOption = 2;
                tableForeground = null;
            } else if (isEncryptedInValidateProcess) {
                errorMessage = Messages.getString("table.file.validate.pdf.encrypted");
                this.setIcon(this.warnIcon);
                this.paneOption = 2;
                tableForeground = null;
            } else {
                errorMessage = ErrorCode.SOURCE_DIR_EMPTY.getDescription();
            }
            String toolTipText = MessageFormat.format(errorMessage, MultiLineTooltips.wrappString(file.getAbsolutePath(), 80));
            this.setToolTipText(MultiLineTooltips.stringToHtml(toolTipText));
            this.getAccessibleContext().setAccessibleDescription(toolTipText);
        }
        if (column == 0) {
            this.setHorizontalAlignment(10);
            this.setText(JComponentUtils.cutString(file.getName(), maxChars, JComponentUtils.CutMode.MODE_MIDDLE));
            if (this.getToolTipText() == null) {
                this.setToolTipText(MultiLineTooltips.wrapToolTip(file.getAbsolutePath(), 80));
                this.getAccessibleContext().setAccessibleDescription(file.getAbsolutePath());
            }
        }
        return tableForeground;
    }

    private boolean mySetSystemIcon(File file, boolean isEncryptedInSignProcess, boolean isEncryptedInValidateProcess) {
        return this.isFileOk(file) && !isEncryptedInSignProcess && !isEncryptedInValidateProcess;
    }

    private void setSystemIcon(File file) {
        try {
            ImageIcon systemIcon = (ImageIcon)FileSystemView.getFileSystemView().getSystemIcon(file);
            systemIcon.getAccessibleContext().setAccessibleName("systemIcon");
            this.setIcon(systemIcon);
            this.paneOption = 1;
        }
        catch (Exception e) {
            this.setIcon(null);
        }
    }

    private void createAllIcons(int tableRowHeight) {
        this.errorIcon = IconScalingUtils.createMultiResIcon("table.cell.red.icon", tableRowHeight, tableRowHeight);
        this.errorRolloverIcon = IconScalingUtils.createMultiResIcon("table.cell.red.rollover.icon", tableRowHeight, tableRowHeight);
        this.errorIcon.getAccessibleContext().setAccessibleName("errorIcon");
        this.errorRolloverIcon.getAccessibleContext().setAccessibleName("errorIcon");
        this.warnIcon = IconScalingUtils.createMultiResIcon("table.verify.yellow.icon", tableRowHeight, tableRowHeight);
        this.warnIcon.getAccessibleContext().setAccessibleName("warnIcon");
        this.okIcon = IconScalingUtils.createMultiResIcon("table.cell.green.icon", tableRowHeight, tableRowHeight);
        this.okRolloverIcon = IconScalingUtils.createMultiResIcon("table.cell.green.rollover.icon", tableRowHeight, tableRowHeight);
        this.okIcon.getAccessibleContext().setAccessibleName("okIcon");
        this.okRolloverIcon.getAccessibleContext().setAccessibleName("okIcon");
    }

    boolean isFileOk(File file) {
        return file.exists() && !file.isDirectory() && file.length() > 0L;
    }

    boolean isEncryptedInSignProcess(boolean isEncrypted) {
        return "sign".equals(Utils.getActiveProcess().getName()) && isEncrypted;
    }

    boolean isEncryptedInValidateProcess(boolean isEncrypted) {
        return "verify".equals(Utils.getActiveProcess().getName()) && isEncrypted;
    }

    public int getPaneOption() {
        return this.paneOption;
    }
}

