/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.renderer;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class BooleanSeenTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Boolean)) {
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Boolean bValue = (Boolean)value;
        this.setHorizontalAlignment(0);
        int iconHeight = table.getRowHeight();
        ImageIcon eyeIcon = IconScalingUtils.createMultiResIcon("table.seenfile.icon", iconHeight, iconHeight);
        this.setIcon(eyeIcon);
        this.setDisabledIcon(IconScalingUtils.dimMultiResIcon(eyeIcon));
        this.setText(null);
        this.setEnabled(bValue);
        StringBuilder filename = new StringBuilder();
        Object object = table.getValueAt(row, column - 1);
        if (object instanceof List) {
            List files = (List)table.getValueAt(row, column - 1);
            for (File file : files) {
                filename.append(file.getName() + " ");
            }
        } else if (object instanceof File) {
            File file = (File)object;
            filename.append(file.getName());
        }
        if (Boolean.TRUE.equals(bValue)) {
            this.setToolTipText(MessageFormat.format(Messages.getString("table.seenfile.tooltip.1"), filename));
        } else {
            this.setToolTipText(MessageFormat.format(Messages.getString("table.seenfile.tooltip.2"), filename));
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

