/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.processfile;

import de.bos_bremen.ecard.client.control.process.impl.Process;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ViewProcessFileTableListener
extends MouseAdapter
implements KeyListener {
    private boolean shown;
    private JTable table;
    private Process process;

    public ViewProcessFileTableListener(Process process) {
        this.process = process;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof JTable)) {
            return;
        }
        JTable jTable = (JTable)object;
        if (!(jTable.getModel() instanceof DefaultTableModel)) {
            return;
        }
        this.table = jTable;
        ViewFilesAction viewFilesAction = null;
        int column = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        ViewableProcessFile result = ((ProcessFileTableModelI)this.table.getModel()).getProcessFileAt(row);
        if (e.isMetaDown()) {
            JPopupMenu popUpMenu = Document.getInstance().getProcessFactory().getProcess(this.process.getProcessName()).getPopUpMenu(this.table, result.getFile());
            if (popUpMenu != null) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
                popUpMenu.show(this.table, e.getPoint().x, e.getPoint().y);
            }
        } else {
            int clicks = e.getClickCount();
            if (clicks == 1 && this.table.getColumnClass(column).equals(ViewFilesAction.class)) {
                viewFilesAction = (ViewFilesAction)this.table.getValueAt(row, column);
            }
            if (clicks == 2 && this.table.getColumnClass(column).equals(File.class)) {
                viewFilesAction = new ViewFilesAction(result);
            }
        }
        if (viewFilesAction == null) {
            return;
        }
        this.shown = this.showFiles(viewFilesAction);
        if (this.shown) {
            this.refreshTable(row);
        }
    }

    private boolean showFiles(ViewFilesAction viewfiles) {
        Document.getInstance().getActionFactory().createShowFileAction(viewfiles).actionPerformed(null);
        return viewfiles.isShowSuccess();
    }

    public void refreshTable(int row) {
        ProcessFileTableModelI model = (ProcessFileTableModelI)this.table.getModel();
        ViewableProcessFile file = model.getProcessFileAt(row);
        try {
            file.setSeen(true);
        }
        catch (SignerException e) {
            Document.getInstance().reportError(e, false, new Object[0]);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof JTable)) {
            return;
        }
        JTable jTable = (JTable)object;
        int keyCode = e.getKeyCode();
        if (keyCode == 10 || keyCode == 32) {
            this.table = jTable;
            this.showSelectedFile();
        }
    }

    private void showSelectedFile() {
        if (this.table == null) {
            return;
        }
        if (!(this.table.getModel() instanceof DefaultTableModel)) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row > -1) {
            ViewableProcessFile result = ((ProcessFileTableModelI)this.table.getModel()).getProcessFileAt(row);
            ViewFilesAction viewFilesAction = new ViewFilesAction(result);
            this.shown = this.showFiles(viewFilesAction);
            if (this.shown) {
                this.refreshTable(row);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

