/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.processfile;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import java.io.File;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessFileTableModel
extends DefaultTableModel
implements ProcessFileTableModelI {
    private static final Logger LOG = LogManager.getLogger(ProcessFileTableModel.class);
    private static final long serialVersionUID = 1L;
    private static final int DATEI_COLUMN = 0;
    private static final int DATEI_SEEN_COLUMN = 1;
    private static final int DATEI_VIEW_COLUMN = 2;
    private String[] columns;

    public ProcessFileTableModel(ProcessName process) {
        this.createColumns(process);
        this.setColumnIdentifiers(this.columns);
    }

    private void createColumns(ProcessName process) {
        this.columns = Document.getInstance().getProcessFactory().getProcess(process).canOpenProcessFile() ? new String[3] : new String[1];
        for (int i = 0; i < this.columns.length; ++i) {
            String header = Messages.getString("view.step." + process.getName() + ".selectfiles.list.header.text" + i);
            this.columns[i] = header.startsWith("!") ? "" : header;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return File.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return ViewFilesAction.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        ViewableProcessFile processFile = this.getProcessFileAt(row);
        if (processFile != null) {
            try {
                switch (column) {
                    case 0: {
                        if (processFile instanceof ProcessSignedFile) {
                            ProcessSignedFile processSignedFile = (ProcessSignedFile)processFile;
                            if (processSignedFile.multipleCmsSignatures) {
                                return processSignedFile.getDetachedFile();
                            }
                        }
                        result = processFile.getFile();
                        break;
                    }
                    case 1: {
                        result = processFile.hasSeen();
                        break;
                    }
                    case 2: {
                        result = new ViewFilesAction(processFile);
                        break;
                    }
                    default: {
                        result = super.getValueAt(row, column);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public ViewableProcessFile getProcessFileAt(int row) {
        Object obj = super.getValueAt(row, 0);
        if (obj instanceof ViewableProcessFile) {
            ViewableProcessFile viewableProcessFile = (ViewableProcessFile)obj;
            return viewableProcessFile;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public void setDataVector(ViewableProcessFile[] dataVector) {
        Object[][] data = new Object[dataVector.length][1];
        for (int i = 0; i < dataVector.length; ++i) {
            data[i][0] = dataVector[i];
        }
        super.setDataVector(data, this.columns);
    }

    @Override
    public void setDataVector(Object[] dataArray) {
        Object[][] data = new Object[dataArray.length][1];
        for (int i = 0; i < dataArray.length; ++i) {
            data[i][0] = dataArray[i];
        }
        super.setDataVector(data, this.columns);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }
}

