/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table.processfile;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.dialog.RedundantDialog;
import de.bos_bremen.ecard.client.gui.view.component.table.JTableWithFTKeys;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.BooleanSeenTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.ProcessFileTableHeaderRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.TableFileRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.ViewFilesActionCellRenderer;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ProcessFileTable
extends JTableWithFTKeys
implements ProcessFileTableI {
    private static final long serialVersionUID = 1L;
    private final boolean canOpenProcessFile;

    public ProcessFileTable(ProcessName process) {
        this.setDefaultRenderer(File.class, new TableFileRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanSeenTableCellRenderer());
        this.setDefaultRenderer(ViewFilesAction.class, new ViewFilesActionCellRenderer());
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.addMouseListener(this.createMouseAdapter());
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new ProcessFileTableHeaderRenderer());
        header.setReorderingAllowed(false);
        header.setResizingAllowed(true);
        this.setShowGrid(false);
        this.canOpenProcessFile = Document.getInstance().getProcessFactory().getProcess(process).canOpenProcessFile();
    }

    @Override
    public int[] getSelectedValues() {
        return this.getSelectedRows();
    }

    @Override
    public void setColumnWidth() {
        if (this.canOpenProcessFile) {
            this.getColumnModel().getColumn(1).setMaxWidth(28);
            this.getColumnModel().getColumn(1).setMinWidth(20);
            this.getColumnModel().getColumn(2).setMaxWidth(28);
            this.getColumnModel().getColumn(2).setMinWidth(20);
        }
    }

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isSelected;
                if (e == null) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    return;
                }
                if (!this.isOnIcon(e.getPoint())) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof ProcessFileTable)) {
                    return;
                }
                ProcessFileTable table = (ProcessFileTable)object;
                int row = table.rowAtPoint(e.getPoint());
                Object rowValue = table.getValueAt(row, 0);
                if (!(rowValue instanceof File)) {
                    return;
                }
                TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(0));
                if (!(renderer instanceof TableFileRenderer)) {
                    return;
                }
                boolean hasFocus = isSelected = true;
                TableFileRenderer fileRenderer = (TableFileRenderer)renderer.getTableCellRendererComponent(table, rowValue, isSelected, hasFocus, row, 0);
                int paneOption = fileRenderer.getPaneOption();
                if (paneOption == 1) {
                    return;
                }
                String optionPaneTitle = paneOption == 2 ? Messages.getString("dialog.optionPane.warning") : Messages.getString("dialog.optionPane.error");
                RedundantDialog.showSimpleOneOptionDialog(fileRenderer.getParent(), optionPaneTitle, fileRenderer.getToolTipText(), paneOption);
            }

            private boolean isOnIcon(Point point) {
                int iconBreite = 24;
                int x = (int)point.getX();
                return 0 <= x && x <= iconBreite;
            }
        };
    }
}

