/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.TableFileRenderer;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class FileSelectTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private transient Vector<Object> columnsName = new Vector();
    private transient Vector<Object> data = new Vector();
    private List<File> files = new ArrayList<File>();

    public FileSelectTable() {
        this.init();
    }

    public FileSelectTable(List<File> files) {
        this.files = files;
        this.init();
    }

    private void init() {
        this.columnsName.add(Messages.getResource("view.step.selectfiles.list.header.text"));
        for (File file : this.files) {
            this.data.add(file);
        }
        this.setDefaultRenderer(File.class, new TableFileRenderer());
        this.setModel(new FileSelectTableModel((Vector)this.data, this.columnsName));
        this.setShowGrid(false);
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new TableFileHeaderRenderer());
        this.setBorder(null);
    }

    public void setListData(List<File> files) {
        this.files = files;
    }

    public void setListData(File[] array) {
        this.files.clear();
        this.files = Arrays.asList(array);
    }

    public void setListData(Object[] array) {
        this.data.clear();
        for (Object o : array) {
            Vector<Object> v = new Vector<Object>();
            v.add(o);
            this.data.add(v);
        }
    }

    public Object[] getSelectedValues() {
        int[] selectedRows;
        ArrayList objects = new ArrayList();
        for (int index : selectedRows = this.getSelectedRows()) {
            Vector v = (Vector)this.data.get(index);
            Object file = v.get(0);
            objects.add(file);
        }
        return objects.toArray();
    }

    public List<File> getFiles() {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (Object o : this.data) {
            Vector v = (Vector)o;
            File file = (File)v.get(0);
            allFiles.add(file);
        }
        return allFiles;
    }

    private static class FileSelectTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public FileSelectTableModel(Vector data, Vector<Object> columnsName) {
            super(data, columnsName);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return File.class;
            }
            return super.getColumnClass(column);
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }
    }

    private static class TableFileHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private TableFileHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value.toString());
            this.setFont(table.getFont());
            this.setBorder(null);
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            return this;
        }
    }
}

