/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table;

import de.bos_bremen.ecard.client.action.DropSelectedFileHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDropTargetHandler
implements DropTargetListener {
    private static final Logger LOG = LogManager.getLogger(FileDropTargetHandler.class);
    private DropSelectedFileHandler handler;

    public FileDropTargetHandler(DropSelectedFileHandler handler) {
        this.handler = handler;
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        LOG.info("drop entered");
        long start = System.currentTimeMillis();
        if (!this.handler.getLicenceTyp().isEditable()) {
            return;
        }
        dtde.acceptDrop(0x40000000);
        Transferable t = dtde.getTransferable();
        List<String> transferables = new ArrayList();
        DataFlavor[] flavors = t.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (!flavor.isFlavorJavaFileListType()) {
                String line;
                InputStream inS;
                Object obj;
                LOG.info("{} isFlavorJavaFileListType() == false", (Object)flavor);
                LOG.info("Repre. class: {}", flavor.getDefaultRepresentationClass());
                LOG.info("Repre. class as String: {}", (Object)flavor.getDefaultRepresentationClassAsString());
                LOG.info("MIME-Type {}", (Object)flavor.getMimeType());
                LOG.info("PrimaryType {}", (Object)flavor.getPrimaryType());
                LOG.info("SubType {}", (Object)flavor.getSubType());
                LOG.info("isFlavorRemoteObjectType() {}", (Object)flavor.isFlavorRemoteObjectType());
                LOG.info("isFlavorSerializedObjectType() {}", (Object)flavor.isFlavorSerializedObjectType());
                if (flavor.getPrimaryType().equalsIgnoreCase("text")) {
                    try {
                        obj = t.getTransferData(flavor);
                        if (obj instanceof InputStream) {
                            inS = (InputStream)obj;
                            Charset charSet = this.getCharSet(flavor);
                            InputStreamReader reader = new InputStreamReader(inS, charSet);
                            try (BufferedReader buffer = new BufferedReader(reader);){
                                String line2 = null;
                                while ((line2 = buffer.readLine()) != null) {
                                    transferables.add(line2);
                                    LOG.info("added: {}", (Object)line2);
                                }
                                break;
                            }
                        }
                        if (obj instanceof Reader) {
                            Reader reader = (Reader)obj;
                            try (BufferedReader buffer = new BufferedReader(reader);){
                                String line3 = null;
                                while ((line3 = buffer.readLine()) != null) {
                                    transferables.add(line3);
                                    LOG.info("added: {}", (Object)line3);
                                }
                                break;
                            }
                        }
                        if (obj instanceof ByteBuffer) {
                            ByteBuffer byteBuffer = (ByteBuffer)obj;
                            line = new String(byteBuffer.array(), StandardCharsets.UTF_8);
                            transferables.add(line);
                            LOG.info("added ByteBuffer: {}", (Object)line);
                            break;
                        }
                        if (obj instanceof String) {
                            String stringObj = (String)obj;
                            transferables.add(stringObj);
                            LOG.info("added String: {}", (Object)stringObj);
                            break;
                        }
                        LOG.info(obj.getClass());
                    }
                    catch (Exception ex) {
                        LOG.error("", (Throwable)ex);
                    }
                    continue;
                }
                if (flavor.getPrimaryType().equalsIgnoreCase("application") && flavor.getSubType().equalsIgnoreCase("x-kde-urilist")) {
                    try {
                        LOG.info("application/x-kde-urilist");
                        obj = t.getTransferData(flavor);
                        LOG.info(obj.getClass());
                        if (!(obj instanceof InputStream)) continue;
                        inS = (InputStream)obj;
                        Charset charSet = this.getCharSet(flavor);
                        InputStreamReader reader = new InputStreamReader(inS, charSet);
                        try (BufferedReader buffer = new BufferedReader(reader);){
                            line = null;
                            while ((line = buffer.readLine()) != null) {
                                LOG.info("added {}", (Object)line);
                            }
                        }
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    continue;
                }
                if (!flavor.getPrimaryType().equalsIgnoreCase("application") || !flavor.getSubType().equalsIgnoreCase("net-signer-client")) continue;
                LOG.info("Es gibt kein DnD innerhalb eines Fensters");
                dtde.dropComplete(false);
                return;
            }
            try {
                transferables = (List)t.getTransferData(flavor);
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
            }
            if (transferables != null) break;
            LOG.error("transferable == null");
            dtde.dropComplete(false);
            LOG.info("drop return");
            return;
        }
        boolean complete = false;
        ArrayList<File> filePathList = new ArrayList<File>();
        ListIterator iter = transferables.listIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            LOG.info("transferable: {}", o);
            if (o instanceof File) {
                File oFile = (File)o;
                LOG.info("instanceof File");
                filePathList.add(oFile);
                complete = true;
            } else if (o instanceof String) {
                String oString = (String)o;
                LOG.info("instanceof String");
                File fileToAdd = new File(oString);
                if (fileToAdd == null || !fileToAdd.exists()) {
                    LOG.info("fileToCopy.exists() {}", (Object)fileToAdd.exists());
                    try {
                        URI uri = new URI((String)o);
                        fileToAdd = new File(uri);
                    }
                    catch (URISyntaxException e) {
                        LOG.warn((Object)e, (Throwable)e);
                    }
                }
                if (fileToAdd != null && fileToAdd.exists()) {
                    filePathList.add(fileToAdd);
                    complete = true;
                } else {
                    LOG.info("Konnte {} nicht als File oeffnen", o);
                }
            } else {
                LOG.info(o.getClass());
            }
            if (complete) {
                this.handler.setFilesToLoad(filePathList.toArray(new File[filePathList.size()]));
            }
            dtde.dropComplete(complete);
        }
        long end = System.currentTimeMillis();
        LOG.info("drop comleted : {}sec", (Object)((double)(end - start) / 1000.0));
    }

    private Charset getCharSet(DataFlavor flavor) {
        StringTokenizer stringToken = new StringTokenizer(flavor.getMimeType(), ";");
        String charsetStr = null;
        do {
            String token;
            if ((token = stringToken.nextToken()).toLowerCase().indexOf("charset=") == -1) continue;
            charsetStr = token.substring(token.toLowerCase().indexOf("charset=") + "charset=".length());
        } while (charsetStr != null && stringToken.hasMoreTokens());
        if (charsetStr != null) {
            return Charset.forName(charsetStr);
        }
        return Charset.defaultCharset();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }
}

