/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.table;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.table.CertificatesTableModel;
import de.bos_bremen.ecard.client.gui.view.component.table.JTableWithFTKeys;
import de.bos_bremen.ecard.client.gui.view.component.table.ViewKeyProviderAction;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.DefaultTableCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.KeyProviderCellRenderer;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.ShowCertificateActionCellRenderer;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CertificatesTable
extends JTableWithFTKeys
implements SelectedCertificateHandler {
    private static final long serialVersionUID = 1L;
    private CertificatesTableModel model = new CertificatesTableModel();

    public CertificatesTable() {
        this.setModel(this.model);
        this.setDefaultRenderer(KeyProvider.class, new KeyProviderCellRenderer());
        this.setDefaultRenderer(ViewKeyProviderAction.class, new ShowCertificateActionCellRenderer());
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new ProcessFileTableHeaderRenderer());
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        this.setShowGrid(false);
        this.addMouseListener(this.createMouseAdapter());
        this.addKeyListener(this.createKeyAdapter());
    }

    private KeyAdapter createKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt == null) {
                    return;
                }
                Object object = evt.getSource();
                if (!(object instanceof JTable)) {
                    return;
                }
                JTable table = (JTable)object;
                if (!table.isEnabled()) {
                    return;
                }
                int keyCode = evt.getKeyCode();
                if (10 == keyCode || 32 == keyCode) {
                    CertificatesTable.this.viewCertificate();
                }
            }
        };
    }

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof JTable)) {
                    return;
                }
                JTable table = (JTable)object;
                if (!(table.getModel() instanceof DefaultTableModel)) {
                    return;
                }
                if (!table.isEnabled()) {
                    return;
                }
                int column = table.columnAtPoint(e.getPoint());
                if (ViewKeyProviderAction.class.equals(table.getColumnClass(column))) {
                    CertificatesTable.this.viewCertificate();
                }
            }
        };
    }

    public void viewCertificate() {
        Document.getInstance().getActionFactory().createShowCertificateAction(this).actionPerformed(null);
    }

    @Override
    public TableModel getModel() {
        return this.model;
    }

    public int[] getSelectedValues() {
        return this.getSelectedRows();
    }

    public int[] getSelectedIndices() {
        return this.getSelectedValues();
    }

    public void setListData(Object[][] data) {
        this.model.setDataVector(data);
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        for (int i = 1; i < this.getColumnCount(); ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            tc.setMaxWidth(28);
            tc.setMinWidth(20);
        }
    }

    public Certificate getSelectedCertificate() {
        return null;
    }

    @Override
    public KeyProvider getSelectedKeyProvider() {
        int[] selectedRows = this.getSelectedIndices();
        try {
            int i = selectedRows[0];
            return (KeyProvider)this.model.getValueAt(i, 0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public KeyUsage getKeyUsage() {
        return KeyUsage.ENCRYPT;
    }

    private static class ProcessFileTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ProcessFileTableHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                String stringValue = (String)value;
                this.setText(stringValue);
                this.setHorizontalAlignment(0);
                JButton btn = new JButton(stringValue);
                btn.setBorder(null);
                btn.setHorizontalAlignment(0);
                btn.setMnemonic(ComponentUtils.getMnemonic("view.step.selectfiles.list.header"));
                return btn;
            }
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

