/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.label;

import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class StepNavigationLabel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int index;
    private StepState state;
    private transient Image completeIcon;
    private transient Image uncompleteIcon;

    public StepNavigationLabel(int stepIndex, boolean isFirstElement, boolean isLastElement, StepState stepState) {
        this.index = stepIndex;
        this.state = stepState;
        this.completeIcon = ComponentUtils.getImage("step.navigation.complete.button");
        this.uncompleteIcon = ComponentUtils.getImage("step.navigation.uncomplete.button");
        this.setPreferredSize(new Dimension(36, 50));
        this.setSize(new Dimension(36, 50));
    }

    public void setStepState(StepState stepState) {
        this.state = stepState;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        int y = size.height / 2;
        int x = size.width / 2;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.state.equals((Object)StepState.complete)) {
            g.setColor(SignerTheme.SIGNER_BLUE);
            g.drawImage(this.completeIcon, x - this.completeIcon.getWidth(null) / 2, y - this.completeIcon.getHeight(null) / 2, null);
        } else {
            g.setColor(Color.WHITE);
            g.drawImage(this.uncompleteIcon, x - this.uncompleteIcon.getWidth(null) / 2, y - this.uncompleteIcon.getHeight(null) / 2, null);
        }
        Font currentFont = UIManager.getFont("Label.font");
        g.setFont(currentFont.getSize() == FontSize.SMALL.getHeaderSize() ? currentFont.deriveFont(1) : currentFont.deriveFont(0));
        g.setColor(this.state.equals((Object)StepState.complete) ? Color.WHITE : SignerTheme.SIGNER_BLUE);
        int ascent = g.getFontMetrics().getAscent();
        int descent = g.getFontMetrics().getDescent();
        int width = g.getFontMetrics().stringWidth("" + (this.index + 1)) - g.getFontMetrics().getLeading();
        g.drawString("" + (this.index + 1), x - width / 2 + g.getFontMetrics().getLeading(), y + (ascent - descent) / 2);
    }

    public static enum StepState {
        complete,
        uncomplete;

    }
}

