/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.label;

import de.bos_bremen.ci_view.CIViewSwing;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.metal.MetalLabelUI;

public class CurvedLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private int cornerRadius = 8;

    public CurvedLabel() {
        this.initGUI();
    }

    public CurvedLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initGUI();
    }

    public CurvedLabel(Icon image) {
        super(image);
        this.initGUI();
    }

    public CurvedLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initGUI();
    }

    public CurvedLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initGUI();
    }

    public CurvedLabel(String text) {
        super(text);
        this.initGUI();
    }

    private void initGUI() {
        Object object = this.getIcon();
        if (object instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)object;
            this.setDisabledIcon(CIViewSwing.TransparencyFilter.createDimmedImage((ImageIcon)imageIcon, (int)150));
        }
        if ((object = this.getBorder()) instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)object;
            CompoundBorder border = BorderFactory.createCompoundBorder(CurvedBorder.createDefault(), compoundBorder.getInsideBorder());
            this.setBorder(border);
        }
        this.setUI(new MetalLabelUI(){

            @Override
            public void update(Graphics g, JComponent c) {
                if (c.isOpaque()) {
                    g.setColor(c.getBackground());
                    g.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), CurvedLabel.this.cornerRadius, CurvedLabel.this.cornerRadius);
                }
                this.paint(g, c);
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.getIcon() != null) {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }
    }
}

