/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.label;

import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

public class AccessibleJLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    CurvedBorder focusCurvedBorder = CurvedBorder.createFocused();

    public AccessibleJLabel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setFocusable(true);
        this.focusCurvedBorder.setLineWidth(2);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccessibleJLabel.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AccessibleJLabel.this.repaint();
            }
        });
    }

    public AccessibleJLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJLabel(Icon image) {
        super(image);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initGUI();
        this.setAccessiableText();
    }

    public AccessibleJLabel(String inText) {
        super(inText);
        this.initGUI();
        this.setAccessiableText();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setAccessiableText();
    }

    private void setAccessiableText() {
        String textHtml = this.getText();
        AccessibleJLabel.setAccessibleContext(textHtml, this.getAccessibleContext());
    }

    public static void setAccessibleContext(String textHtml, AccessibleContext accessibleContext) {
        if (textHtml == null) {
            return;
        }
        String header = "";
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "html");
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "br");
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "b");
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "i");
        if (((String)(textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "hr"))).indexOf("<h1>") != -1 && ((String)textHtml).indexOf("</h1>") != -1) {
            header = ((String)textHtml).substring(((String)textHtml).indexOf("<h1>") + 4, ((String)textHtml).indexOf("</h1>"));
            textHtml = ((String)textHtml).substring(0, ((String)textHtml).indexOf("<h1>")) + ((String)textHtml).substring(((String)textHtml).indexOf("</h1>"));
        }
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "h1");
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "h2");
        textHtml = AccessibleJLabel.removeHTMLTAG((String)textHtml, "h3");
        accessibleContext.setAccessibleName(header);
        accessibleContext.setAccessibleDescription((String)textHtml);
    }

    private static String removeHTMLTAG(String textHtml, String string) {
        textHtml = textHtml.replace(new StringBuilder("<" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("</" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("<" + string + "/>"), new StringBuilder(""));
        return textHtml;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.hasFocus()) {
            this.focusCurvedBorder.paintBorder(this, g, 0, 0, this.getSize().width, this.getSize().height);
        }
        super.paintComponent(g);
    }
}

