/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.filechooser;

import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChooserFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileChooserFactory.class);
    private static HashMap<String, Icon> iconCacheMap = new HashMap();

    public static HashMap<String, Icon> getFileChooserIconCacheMap() {
        return iconCacheMap;
    }

    public static JFileChooser defaultFileChooser() {
        File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        log.debug("default directory = {}", (Object)defaultDir);
        return FileChooserFactory.createFileChooser(defaultDir);
    }

    public static JFileChooser createFileChooser(File directory) {
        log.info("directory = {}", (Object)directory);
        JFileChooser chooser = new JFileChooser(directory){
            private static final long serialVersionUID = 1L;

            @Override
            public Icon getIcon(File f) {
                Icon fileIcon = null;
                fileIcon = FileChooserFactory.getIconFromSystemOrCache(f);
                if (fileIcon == null) {
                    fileIcon = super.getIcon(f);
                }
                return fileIcon;
            }
        };
        return chooser;
    }

    public static Icon getIconFromSystemOrCache(File f) {
        String fileName;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (fileSystemView == null) {
            return null;
        }
        boolean isSpecialSystemDirectory = FileChooserFactory.isSpecialSystemDirectory(fileSystemView, f);
        Icon fileIcon = null;
        String systemDescription = fileSystemView.getSystemTypeDescription(f);
        fileIcon = FileChooserFactory.tryGetFileIconFromCache(f, isSpecialSystemDirectory, systemDescription, fileName = f.getName());
        if (fileIcon == null) {
            fileIcon = fileSystemView.getSystemIcon(f);
            if (fileIcon != null) {
                FileChooserFactory.putInCache(isSpecialSystemDirectory, f, fileIcon);
            } else {
                log.trace("system icon ist null -> java-default icon verwenden f\u00fcr '" + fileName + "'  '" + systemDescription + "'");
            }
        }
        return fileIcon;
    }

    public static Icon putInCache(boolean isbesondererSystemDir, File f, Icon icon) {
        if (icon == null) {
            return null;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        String systemDescription = fileSystemView.getSystemTypeDescription(f);
        boolean isSystemDescValid = FileChooserFactory.isKeyCandidateValid(systemDescription);
        String fileName = f.getName();
        boolean isFileNameValid = FileChooserFactory.isKeyCandidateValid(fileName);
        if (f.isFile() && isSystemDescValid) {
            iconCacheMap.put(systemDescription, icon);
        } else if (isbesondererSystemDir && isFileNameValid) {
            iconCacheMap.put(fileName, icon);
        } else if (f.isDirectory()) {
            if (!isSystemDescValid) {
                iconCacheMap.put(fileName, icon);
            } else {
                iconCacheMap.put(systemDescription, icon);
            }
        } else {
            log.trace("sonst kein icon-cache f\u00fcr: '{}' '{}'", (Object)fileName, (Object)systemDescription);
        }
        return icon;
    }

    private static boolean isSpecialSystemDirectory(FileSystemView fileSystemView, File file) {
        return fileSystemView.isDrive(file) && fileSystemView.isFileSystem(file) && fileSystemView.isFileSystemRoot(file);
    }

    private static boolean isKeyCandidateValid(String keyCandidate) {
        return keyCandidate != null && !keyCandidate.isEmpty();
    }

    private static Icon tryGetFileIconFromCache(File f, boolean isSpecialSystemDirectory, String systemDescription, String fileName) {
        boolean isSystemDescValid = FileChooserFactory.isKeyCandidateValid(systemDescription);
        boolean isFileNameValid = FileChooserFactory.isKeyCandidateValid(fileName);
        Icon fileIcon = null;
        if (f.isFile() && isSystemDescValid) {
            fileIcon = iconCacheMap.get(systemDescription);
        } else if (isSpecialSystemDirectory && isFileNameValid) {
            fileIcon = iconCacheMap.get(fileName);
        } else if (f.isDirectory()) {
            fileIcon = !isSystemDescValid ? iconCacheMap.get(fileName) : iconCacheMap.get(systemDescription);
        } else {
            log.trace("get failed -> system Icon abfragen -> '{}' '{}'", (Object)fileName, (Object)systemDescription);
        }
        return fileIcon;
    }
}

