/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IconButtonUtil {
    private static final String RESOURCES = "/resources/";
    private static final Logger LOG = LogManager.getLogger(IconButtonUtil.class);

    private IconButtonUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void configureButton(AbstractButton button) {
        button.setBorder(CurvedBorder.EMPTY_BORDER);
        button.addFocusListener(ComponentUtils.createFocusListenerFor(button));
        button.addMouseListener(ComponentUtils.createMouseAdapterFor(button));
        button.setContentAreaFilled(false);
    }

    public static void configureButton(AbstractButton button, String buttonKey) {
        ImageIcon icon = (ImageIcon)ComponentUtils.getIcon(buttonKey);
        ImageIcon rolloverIcon = (ImageIcon)ComponentUtils.getIcon(buttonKey + ".rollover");
        String text = Messages.getResource(buttonKey + ".text");
        String textPosition = Messages.getResource(buttonKey + ".text.position", "Bottom");
        String tooltip = Messages.getResource(buttonKey + ".tooltip");
        button.setMnemonic(Messages.getString(buttonKey + ".mnemonic").charAt(0));
        if (icon != null) {
            button.setIcon(icon);
            button.setDisabledIcon(IconScalingUtils.dimMultiResIcon(icon));
        }
        if (rolloverIcon != null) {
            button.setRolloverEnabled(true);
            button.setRolloverIcon(rolloverIcon);
            button.setPressedIcon(rolloverIcon);
        }
        if (text != null) {
            button.setText(text);
            button.getAccessibleContext().setAccessibleName(text);
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
            button.getAccessibleContext().setAccessibleDescription(tooltip);
        }
        IconButtonUtil.setTextPositionFor(textPosition, button);
        IconButtonUtil.configureButton(button);
    }

    public static void configureButton(AbstractButton button, String buttonKey, boolean navigate) {
        if (!navigate) {
            return;
        }
        ImageIcon icon = (ImageIcon)ComponentUtils.getIcon(buttonKey);
        ImageIcon rolloverIcon = (ImageIcon)ComponentUtils.getIcon(buttonKey + ".rollover");
        String text = Messages.getResource(buttonKey + ".text");
        String tooltip = Messages.getResource(buttonKey + ".tooltip");
        button.setMnemonic(Messages.getString(buttonKey + ".mnemonic").charAt(0));
        if (icon != null) {
            button.setIcon(icon);
            button.setDisabledIcon(IconScalingUtils.dimMultiResIcon(icon));
        }
        if (rolloverIcon != null) {
            button.setRolloverEnabled(true);
            button.setRolloverIcon(rolloverIcon);
            button.setPressedIcon(rolloverIcon);
        }
        if (text != null) {
            button.setText(text);
            button.getAccessibleContext().setAccessibleName(text);
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
            button.getAccessibleContext().setAccessibleDescription(tooltip);
        }
        button.setBorder(CurvedBorder.EMPTY_BORDER);
        button.setContentAreaFilled(false);
    }

    public static void configureIconButton(final IconButton buttonWithoutText, String buttonKey) {
        final ImageIcon icon = (ImageIcon)ComponentUtils.getIcon(buttonKey);
        final ImageIcon rolloverIcon = (ImageIcon)ComponentUtils.getIcon(buttonKey + ".rollover");
        String tooltip = Messages.getResource(buttonKey + ".tooltip");
        if (icon != null) {
            buttonWithoutText.setIcon(icon);
        }
        if (rolloverIcon != null) {
            buttonWithoutText.setRolloverEnabled(true);
            buttonWithoutText.setRolloverIcon(rolloverIcon);
            buttonWithoutText.setPressedIcon(rolloverIcon);
            buttonWithoutText.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    buttonWithoutText.setIcon(rolloverIcon);
                    buttonWithoutText.setBorder(CurvedBorder.EMPTY_BORDER);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    buttonWithoutText.setIcon(buttonWithoutText.isSelected() ? rolloverIcon : icon);
                }
            });
        }
        if (tooltip != null) {
            buttonWithoutText.setToolTipText(tooltip);
            buttonWithoutText.getAccessibleContext().setAccessibleDescription(tooltip);
        }
        buttonWithoutText.setContentAreaFilled(false);
    }

    public static void setAction(AbstractButton button, Action newAction, String textPosition) {
        if (((AbstractSignerAction)newAction).hasIcon()) {
            IconButtonUtil.setTextPositionFor(textPosition, button);
            IconButtonUtil.configureButton(button);
        }
    }

    private static AbstractButton setTextPositionFor(String textPosition, AbstractButton button) {
        if (textPosition.equalsIgnoreCase("Top")) {
            button.setVerticalTextPosition(1);
            button.setHorizontalTextPosition(0);
        }
        if (textPosition.equalsIgnoreCase("Bottom")) {
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
        }
        if (textPosition.equalsIgnoreCase("Right")) {
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(4);
        }
        if (textPosition.equalsIgnoreCase("Left")) {
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(2);
        }
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static ImageIcon getPropertyIcon(String actionKeyName) {
        actionIconScale = actionKeyName + ".icon.scale";
        result = null;
        iconName = Messages.getResource(actionKeyName + ".icon");
        scaleInt = 16;
        scaleIcon = true;
        if (Messages.getResource(actionIconScale) != null) {
            try {
                scaleInt = Integer.parseInt(Messages.getResource(actionIconScale));
            }
            catch (Exception e) {
                try {
                    scaleIcon = Boolean.parseBoolean(Messages.getResource(actionIconScale, Boolean.TRUE.toString()));
                }
                catch (Exception ex) {
                    IconButtonUtil.LOG.debug(ex.getMessage());
                }
            }
        }
        if (iconName != null && (resource = AbstractSignerAction.class.getResource("/resources/" + iconName)) != null) {
            originalImage = Toolkit.getDefaultToolkit().createImage(resource);
            if (!iconName.endsWith("_24.png") && !iconName.endsWith(".svg") && scaleIcon) {
                is = null;
                try {
                    path = "/resources/" + iconName.substring(0, iconName.length() - 4) + "_24.png";
                    is = AbstractSignerAction.class.getResourceAsStream(path);
                    if (is == null) ** GOTO lbl38
                    smallOne = Toolkit.getDefaultToolkit().createImage(AbstractSignerAction.class.getResource(path));
                    result = new ImageIcon(smallOne);
                }
                catch (Throwable e) {
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            IconButtonUtil.LOG.debug("");
                        }
                    }
                }
            } else {
                result = IconScalingUtils.createMultiResIcon(actionKeyName + ".icon");
            }
lbl38:
            // 4 sources

            if (result == null) {
                result = new ImageIcon(originalImage.getScaledInstance(scaleInt, scaleInt, 4));
            }
        }
        return result;
    }

    public static ImageIcon getRolloverIcon(String actionKeyName) {
        String iconName = Messages.getResource(actionKeyName + ".rollover.icon");
        if (iconName == null) {
            return null;
        }
        URL resource = AbstractSignerAction.class.getResource(RESOURCES + iconName);
        if (resource == null) {
            return null;
        }
        return IconScalingUtils.createMultiResIcon(actionKeyName + ".rollover.icon");
    }
}

