/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButtonUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class IconButton
extends JButton {
    private static final long serialVersionUID = -7034647486756170426L;
    private boolean hidden = false;
    private transient Action realAction = null;
    private ImageIcon emptyImage;
    private boolean isSelected = false;

    public IconButton(String buttonKey) {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setFocusPainted(false);
        IconButtonUtil.configureButton(this, buttonKey);
    }

    public IconButton(String buttonKey, boolean navigate) {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setFocusPainted(false);
        IconButtonUtil.configureButton(this, buttonKey, navigate);
    }

    public IconButton() {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setFocusPainted(false);
        IconButtonUtil.configureButton(this);
    }

    public IconButton(String buttonKey, String text) {
        this(buttonKey);
        if (text != null) {
            this.setText(text);
            this.getAccessibleContext().setAccessibleName(text);
        }
    }

    public IconButton(boolean newSelected) {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setFocusPainted(false);
        this.isSelected = newSelected;
        IconButtonUtil.configureButton(this);
    }

    @Override
    public void setAction(Action action) {
        String shortcut;
        this.realAction = action;
        String actionKeyName = ((AbstractSignerAction)action).getActionKeyName();
        this.setName(actionKeyName);
        if (((AbstractSignerAction)action).hasIcon()) {
            String textPosition = Messages.getResource(actionKeyName + ".text.position", "Bottom");
            IconButtonUtil.setAction(this, action, textPosition);
        }
        super.setAction(action);
        this.setDisabledIcon(((AbstractSignerAction)action).getDisabledIcon());
        this.setContentAreaFilled(false);
        String tooltipText = Messages.getResource(actionKeyName + ".tooltip");
        this.setToolTipText(tooltipText);
        this.getAccessibleContext().setAccessibleDescription(tooltipText);
        KeyStroke ksPressedEnter = KeyStroke.getKeyStroke(10, 0, false);
        this.getInputMap(0).put(ksPressedEnter, actionKeyName);
        this.getActionMap().put(actionKeyName, action);
        char mnemonic = ComponentUtils.getMnemonic(actionKeyName);
        if (mnemonic != '\u0000') {
            KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic);
            this.getInputMap(2).put(ks, actionKeyName);
            this.getActionMap().put(actionKeyName, action);
            this.setMnemonic(mnemonic);
        }
        if ((shortcut = Messages.getResource(actionKeyName + ".key")) != null && !shortcut.isEmpty()) {
            KeyStroke ks = KeyStroke.getKeyStroke(shortcut);
            this.getInputMap(2).put(ks, actionKeyName);
            this.getActionMap().put(actionKeyName, action);
        }
    }

    public void setAbstractAction(AbstractAction abstractAction) {
        super.setAction(abstractAction);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean newHidden) {
        boolean oldValue = this.hidden;
        this.hidden = newHidden;
        if (oldValue != newHidden || newHidden && this.isVisible()) {
            if (this.hidden) {
                super.setAction(new EmptyAction(this));
                this.setPressedIcon(this.emptyImage);
                this.setRolloverIcon(this.emptyImage);
                this.setDisabledIcon(this.emptyImage);
                this.setOpaque(true);
                this.setVisible(true);
                this.setEnabled(false);
                this.setFocusable(false);
            } else if (this.realAction != null) {
                this.setAction(this.realAction);
                this.setVisible(true);
                this.setDisabledIcon(null);
                this.setFocusable(true);
                this.revalidate();
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setForeground(new JButton().getForeground());
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void setSelected(boolean newSelected) {
        this.isSelected = newSelected;
        this.setBorder(newSelected ? CurvedBorder.ACTIVE_BORDER_THIN : CurvedBorder.EMPTY_BORDER);
    }

    private class EmptyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public EmptyAction(IconButton button) {
            int width = 32;
            int height = 32;
            if (button.getIcon() != null) {
                width = button.getIcon().getIconWidth() > 0 ? button.getIcon().getIconWidth() : 1;
                height = button.getIcon().getIconHeight() > 0 ? button.getIcon().getIconHeight() : 1;
            }
            GraphicsConfiguration gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage image = gfxConf.createCompatibleImage(width, height);
            Graphics2D g = image.createGraphics();
            g.setBackground(button.getBackground());
            g.setColor(button.getBackground());
            g.fillRect(0, 0, width, height);
            IconButton.this.emptyImage = new ImageIcon(image);
            this.putValue("ToolTipText", null);
            this.putValue("SmallIcon", IconButton.this.emptyImage);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }
}

