/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButtonUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.apps.rasterizer.Messages;

public class CurvedToggleIconButton
extends CurvedToggleButton {
    private static final long serialVersionUID = 1L;
    private String alias;

    public CurvedToggleIconButton(String buttonKey) {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setBackground(Color.white);
        this.setFocusPainted(true);
        IconButtonUtil.configureButton(this, buttonKey);
        this.addChangeListener(this.createChangeLis());
    }

    public CurvedToggleIconButton() {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setBackground(Color.white);
        this.setFocusPainted(true);
        this.addChangeListener(this.createChangeLis());
    }

    public CurvedToggleIconButton(String buttonKey, String text) {
        this(buttonKey, text, null);
    }

    public CurvedToggleIconButton(String buttonKey, String text, String alias) {
        this(buttonKey);
        this.alias = alias;
        if (text != null) {
            this.setText(text);
            this.getAccessibleContext().setAccessibleName(text);
            this.setToolTipText(Messages.get((String)(buttonKey + ".tooltip"), (String)text));
            this.setFocusPainted(true);
        }
    }

    public CurvedToggleIconButton(String buttonKey, String buttonText, String tooltipText, String alias) {
        this(buttonKey);
        this.alias = alias;
        if (buttonText != null) {
            this.setText(buttonText);
            this.getAccessibleContext().setAccessibleName(buttonText);
            this.setToolTipText(tooltipText);
            this.setFocusPainted(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width += 10;
        return preferredSize;
    }

    @Override
    public void setAction(Action action) {
        String actionKeyName;
        super.setAction(action);
        if (((AbstractSignerAction)action).hasIcon()) {
            actionKeyName = ((AbstractSignerAction)action).getActionKeyName();
            IconButtonUtil.setAction(this, action, actionKeyName);
        }
        actionKeyName = ((AbstractSignerAction)action).getActionKeyName();
        KeyStroke ksPressedEnter = KeyStroke.getKeyStroke(10, 0, false);
        this.getInputMap(0).put(ksPressedEnter, actionKeyName);
        this.getActionMap().put(actionKeyName, action);
    }

    @Override
    public void addActionListener(ActionListener action) {
        super.addActionListener(action);
        if (action instanceof AbstractSignerAction) {
            AbstractSignerAction abstractSignerAction = (AbstractSignerAction)action;
            String actionKeyName = abstractSignerAction.getActionKeyName();
            KeyStroke ksPressedEnter = KeyStroke.getKeyStroke(10, 0, false);
            this.getInputMap(0).put(ksPressedEnter, actionKeyName);
            this.getActionMap().put(actionKeyName, abstractSignerAction);
        }
    }

    @Override
    protected Insets createFocusBorderInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        super.getAccessibleContext().setAccessibleName(text);
        this.setToolTipText(MultiLineTooltips.wrapToolTip(text));
    }

    public String getAlias() {
        return this.alias;
    }

    private ChangeListener createChangeLis() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CurvedToggleIconButton.this.setBorder(CurvedToggleIconButton.this.hasFocus() ? CurvedBorder.FOCUSED_BORDER : CurvedBorder.EMPTY_BORDER);
                if (CurvedToggleIconButton.this.isSelected() && CurvedToggleIconButton.this.isEnabled()) {
                    CurvedToggleIconButton.this.setBorder(CurvedBorder.ACTIVE_BORDER);
                }
            }
        };
    }
}

