/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButtonUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.metal.MetalButtonUI;

public class CurvedButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private int cornerRadius = 8;

    public CurvedButton() {
        this.initGUI();
    }

    private void initGUI() {
        Border border = this.getBorder();
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            border = BorderFactory.createCompoundBorder(CurvedBorder.createCurvedBorder(SignerTheme.SIGNER_BLUE_2), compoundBorder.getInsideBorder());
            this.setBorder(border);
        } else {
            border = BorderFactory.createCompoundBorder(CurvedBorder.createCurvedBorder(SignerTheme.SIGNER_BLUE_2), this.getBorder());
            this.setBorder(border);
        }
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setUI(new MetalButtonUI(){
            CurvedBorder focusCurvedBorder = CurvedBorder.FOCUSED_BORDER;

            @Override
            protected void paintButtonPressed(Graphics g, AbstractButton b) {
                if (b.isContentAreaFilled()) {
                    g.setColor(this.getSelectColor());
                    g.fillRoundRect(0, 0, b.getWidth(), b.getHeight(), CurvedButton.this.cornerRadius, CurvedButton.this.cornerRadius);
                }
            }

            @Override
            protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
                this.focusCurvedBorder.setLineWidth(2);
                if (CurvedButton.this.hasFocus()) {
                    this.focusCurvedBorder.paintBorder(b, g, 3, 3, b.getSize().width - 6, b.getSize().height - 6);
                }
            }
        });
    }

    @Override
    public void setAction(Action newAction) {
        super.setAction(newAction);
        if (((AbstractSignerAction)newAction).hasIcon()) {
            String actionKeyName = ((AbstractSignerAction)newAction).getActionKeyName();
            IconButtonUtil.setAction(this, newAction, actionKeyName);
            KeyStroke ksPressedEnter = KeyStroke.getKeyStroke(10, 0, false);
            int codition2 = 0;
            this.getInputMap(codition2).put(ksPressedEnter, actionKeyName);
            this.getActionMap().put(actionKeyName, newAction);
        }
        this.initGUI();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.getIcon() != null) {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }
    }
}

