/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class AccessibleRadioButton
extends JRadioButton {
    private static final long serialVersionUID = 1L;
    private static final CurvedBorder focusCurvedBorder = CurvedBorder.FOCUSED_BORDER;
    private String toolTipText;

    public AccessibleRadioButton() {
        this.initAccessibleContext();
    }

    private void initAccessibleContext() {
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.setFocusPainted(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AccessibleRadioButton.this.doClick(0);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus()) {
            focusCurvedBorder.paintBorder(this, g, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public AccessibleRadioButton(Icon icon) {
        super(icon);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(Action a) {
        super(a);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(Icon icon, boolean selected) {
        super(null, icon, selected);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(String text) {
        super(text, null, false);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(String text, boolean selected) {
        super(text, null, selected);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(String text, Icon icon) {
        super(text, icon, false);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.initAccessibleContext();
    }

    public AccessibleRadioButton(String text, String tooltipText) {
        super(text);
        this.toolTipText = tooltipText;
        if (this.toolTipText != null && !this.toolTipText.isEmpty()) {
            this.setToolTipText(MultiLineTooltips.wrapToolTip(this.toolTipText));
        }
        this.initAccessibleContext();
    }

    @Override
    public void setSelected(boolean newSelected) {
        super.setSelected(newSelected);
        this.revalidate();
    }
}

