/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component.buttons;

import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class AccessibleJToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    CurvedBorder focusCurvedBorder = CurvedBorder.createFocused();

    public AccessibleJToggleButton() {
        this.initAccessibleContext();
    }

    private void initAccessibleContext() {
        this.setFocusPainted(false);
        this.focusCurvedBorder.setLineWidth(2);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccessibleJToggleButton.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AccessibleJToggleButton.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus()) {
            this.focusCurvedBorder.paintBorder(this, g, 3, 3, this.getSize().width - 6, this.getSize().height - 6);
        }
    }

    public AccessibleJToggleButton(Action a) {
        super(a);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(Icon icon, boolean selected) {
        super(icon, selected);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(Icon icon) {
        super(icon);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(String text, boolean selected) {
        super(text, selected);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(String text, Icon icon) {
        super(text, icon);
        this.initAccessibleContext();
    }

    public AccessibleJToggleButton(String text) {
        super(text);
        this.initAccessibleContext();
    }
}

