/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ValueWithLabelPanel
extends GridBagPanel {
    private static final long serialVersionUID = 1L;
    private JLabel signOption;
    private JLabel selectedValue;
    CurvedBorder focusCurvedBorder = CurvedBorder.FOCUSED_BORDER;

    public ValueWithLabelPanel(String signOptionKey) {
        this.setText(signOptionKey);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ValueWithLabelPanel.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ValueWithLabelPanel.this.repaint();
            }
        });
    }

    private void setText(String signOptionKey) {
        this.signOption = new HeaderLabel(signOptionKey);
        this.selectedValue = new JLabel("--");
        Insets insets = new Insets(3, 3, 3, 3);
        int anchor = 18;
        int anchorLabel = 12;
        this.add((Component)this.signOption, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, anchorLabel, 0, insets, 0, 0));
        this.add((Component)this.selectedValue, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, anchor, 2, insets, 0, 0));
    }

    public void setValue(String valueText) {
        this.setValue(valueText, valueText);
    }

    public void setValue(String selectedValueText, String toolTip) {
        this.selectedValue.setText(selectedValueText);
        this.getAccessibleContext().setAccessibleName(this.signOption.getText() + " " + this.selectedValue.getText());
        this.getAccessibleContext().setAccessibleDescription("");
        this.revalidate();
        this.repaint();
        String tooltipText = this.signOption.getText() + " " + Utils.htmlToAscii(toolTip != null ? toolTip : selectedValueText);
        this.setToolTipText(MultiLineTooltips.wrapToolTip(tooltipText));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus()) {
            this.focusCurvedBorder.paintBorder(this, g, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    private static class HeaderLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public HeaderLabel(String signOptionKey) {
            super(Messages.getString(signOptionKey));
            this.setFont(UIManager.getFont("Label.font").deriveFont(1));
            this.setForeground(SignerTheme.GRAY_5);
            this.setOpaque(false);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setFocusable(false);
        }
    }
}

