/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class TopSideBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private int thickness = 2;
    private Color lineColor = UIManager.getColor("Separator.foreground");
    private int space = 10;

    public TopSideBorder() {
    }

    public TopSideBorder(int t) {
        this.thickness = t;
    }

    public TopSideBorder(Color c) {
        this.lineColor = c;
    }

    public TopSideBorder(int t, Color c) {
        this.thickness = t;
        this.lineColor = c;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            g.drawLine(x + this.space + i, y + 4 + i, x + w - this.space, y + 4 + i);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness * 3, this.thickness * 3, this.thickness * 3, this.thickness * 3);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.bottom = i.top = this.thickness * 3;
        i.right = i.top;
        i.left = i.top;
        return i;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

