/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.gui.view.component.StatusLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.governikus.csl.ECardProgressListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusLine
extends JPanel
implements ECardProgressListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private StatusLabel statusLabel;

    public StatusLine() {
        this.initGUI();
        Document.getInstance().addProgressListener(this);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.progressBar = new JProgressBar();
        this.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(14, 3, 3, 3), 0, 0));
        int nettoHeigth = this.progressBar.getPreferredSize().height;
        this.progressBar.setPreferredSize(new Dimension(150, nettoHeigth));
        this.progressBar.setMaximumSize(new Dimension(150, nettoHeigth));
        this.progressBar.setMinimumSize(new Dimension(150, nettoHeigth));
        this.setPreferredSize(new Dimension(2, 6 + nettoHeigth));
        this.statusLabel = new StatusLabel();
        this.add((Component)this.statusLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.1, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    public void notifyProgress(ECardProgressListener.ProgressType arg0, double arg1) {
        if (Double.isInfinite(arg1) || Double.isNaN(arg1) || arg0 == null) {
            arg1 = 0.0;
        }
        if (arg1 < 0.0) {
            this.statusLabel.setStatus(null);
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.statusLabel.setStatus(arg0);
            this.progressBar.setValue((int)(arg1 * 100.0));
        }
    }

    @Override
    public void setVisible(boolean flag) {
        this.progressBar.setVisible(flag);
        this.statusLabel.setVisible(flag);
    }
}

