/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class SkipStepPanel
extends JPanel
implements StepChangedListener {
    private static final long serialVersionUID = 1L;
    private transient SkipStepHandler skipStepHandler;
    private JCheckBox skipStep;

    public SkipStepPanel(SkipStepHandler skipstepHandler) {
        this.skipStepHandler = skipstepHandler;
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.skipStep = new JCheckBox(Messages.getString("button.step.skip.text"));
        this.skipStep.setMargin(new Insets(0, 0, 0, 0));
        this.skipStep.setFocusPainted(false);
        this.skipStep.setSelected(this.skipStepHandler.getSkipStep());
        this.skipStep.addFocusListener(this.createFocusListenerFor(this.skipStep));
        this.skipStep.addActionListener(e -> this.skipStepHandler.setSkipStep(this.skipStep.isSelected()));
        this.add(this.skipStep);
        JComponentUtils.setLookByLicence(this.skipStep, this.skipStepHandler.getSkippableStep().getLicenceTyp());
        this.setVisible(Document.getInstance().isSaveConfig());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.skipStep.setSelected(this.skipStepHandler.getSkipStep());
        this.skipStep.setEnabled(this.skipStepHandler.isStepComplete());
        JComponentUtils.setLookByLicence(this.skipStep, this.skipStepHandler.getSkippableStep().getLicenceTyp());
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }

    public boolean isSkipStepEnabled() {
        return this.skipStep.isEnabled();
    }

    private FocusListener createFocusListenerFor(final JCheckBox skipStep) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SkipStepPanel parent = (SkipStepPanel)skipStep.getParent();
                parent.setBorder(CurvedBorder.FOCUSED_BORDER);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SkipStepPanel parent = (SkipStepPanel)skipStep.getParent();
                parent.setBorder(CurvedBorder.EMPTY_BORDER);
            }
        };
    }

    public JCheckBox getSkipStep() {
        return this.skipStep;
    }
}

