/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BaseMultiResolutionImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NavigationPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(NavigationPanel.class);
    private static final long serialVersionUID = 9009465015024868306L;
    private final transient ProcessName process;
    private IconButton iconAboutButton;

    public NavigationPanel(ProcessName newProcess) {
        LOG.trace("");
        this.process = newProcess;
        this.initGUI(this.process);
        LocaleChanger.getInstance().addObserver(this);
    }

    public void setContent(JPanel content) {
        this.add((Component)content, "North");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setBorder(this.process.isRootProcess() ? BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 2, 2, 2), CurvedBorder.DEFAULT_BORDER) : ComponentUtils.createTitledCurvedBorderForTitle(this.process.getDisplayName()));
        this.setFocusable(false);
        this.configureInfoButton();
        this.revalidate();
        this.repaint();
    }

    private void initGUI(ProcessName process) {
        LOG.trace("");
        this.setLayout(new BorderLayout());
        if (process == null || process.isRootProcess()) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 2, 2, 2), CurvedBorder.DEFAULT_BORDER));
        } else {
            this.setName(process.getDisplayName());
            this.getAccessibleContext().setAccessibleName(process.getDisplayName());
            this.setToolTipText(Messages.getResource("process.navigation.tooltip"));
            this.getAccessibleContext().setAccessibleDescription(Messages.getResource("process.navigation.tooltip"));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 7, 0), ComponentUtils.createTitledCurvedBorderForTitle(process.getDisplayName())));
        }
        try {
            this.iconAboutButton = new IconButton();
            this.configureInfoButton();
            this.add((Component)this.iconAboutButton, "South");
        }
        catch (MissingResourceException ex) {
            LOG.debug("no icon to set");
        }
    }

    private void configureInfoButton() {
        if (this.iconAboutButton == null) {
            return;
        }
        this.iconAboutButton.getAccessibleContext().setAccessibleName(Messages.getResource("action.info"));
        String signerIcon = System.getProperty("logo.icon");
        int width = Integer.parseInt(System.getProperty("logo.icon.width"));
        int height = Integer.parseInt(System.getProperty("logo.icon.height"));
        BaseMultiResolutionImage image = IconScalingUtils.createMultiResImage(AbstractSignerAction.class.getResource("/resources/" + signerIcon), width, height);
        ImageIcon signerLogo = new ImageIcon(image);
        this.iconAboutButton.setBorder(CurvedBorder.EMPTY_BORDER);
        this.iconAboutButton.setAction(Document.getInstance().getActionFactory().getInfoAction());
        this.iconAboutButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.iconAboutButton.setFocusPainted(false);
        this.iconAboutButton.setIcon(signerLogo);
        this.iconAboutButton.setRolloverEnabled(false);
        this.iconAboutButton.setPressedIcon(signerLogo);
        this.iconAboutButton.setText("");
        this.iconAboutButton.setEnabled(true);
    }
}

