/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import javax.swing.JComponent;

public class LocaleChanger {
    private Locale actualLocale = Locale.GERMAN;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static LocaleChanger instance = null;

    private LocaleChanger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleChanger getInstance() {
        Class<LocaleChanger> clazz = LocaleChanger.class;
        synchronized (LocaleChanger.class) {
            if (instance == null) {
                instance = new LocaleChanger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale newLocale, boolean force) {
        if (newLocale == null) {
            return;
        }
        LocaleChanger localeChanger = instance;
        synchronized (localeChanger) {
            Locale old = this.actualLocale;
            if (!newLocale.equals(old)) {
                this.actualLocale = newLocale;
                Locale.setDefault(newLocale);
                JComponent.setDefaultLocale(newLocale);
                Config.getInstance().setLocale(newLocale);
                Messages.setLocale(newLocale);
                ErrorCode.setLocale(newLocale);
            }
            if (!force) {
                return;
            }
            this.pcs.firePropertyChange("Locale", old, this.actualLocale);
            if (old.equals(this.actualLocale)) {
                for (PropertyChangeListener pc : this.pcs.getPropertyChangeListeners()) {
                    pc.propertyChange(new PropertyChangeEvent(this, "Locale", old, this.actualLocale));
                }
            }
        }
    }

    public Locale getActualLocale() {
        return this.actualLocale;
    }

    public void addObserver(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }
}

