/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.TitledCurvedBorder;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JComponentUtils {
    private static final Logger LOG = LogManager.getLogger(JComponentUtils.class);

    public static JLabel createLabel(String componentKey, boolean isOpaque) {
        JLabel label = new JLabel();
        label.setText(Messages.getString(componentKey));
        label.setIcon(ComponentUtils.getIcon(componentKey));
        String textPosition = Messages.getResource(componentKey + "text.position", "Bottom");
        if (textPosition.equalsIgnoreCase("Top")) {
            label.setVerticalTextPosition(1);
            label.setHorizontalTextPosition(0);
        }
        if (textPosition.equalsIgnoreCase("Bottom")) {
            label.setVerticalTextPosition(3);
            label.setHorizontalTextPosition(0);
        }
        if (textPosition.equalsIgnoreCase("Right")) {
            label.setVerticalTextPosition(0);
            label.setHorizontalTextPosition(4);
        }
        if (textPosition.equalsIgnoreCase("Left")) {
            label.setVerticalTextPosition(0);
            label.setHorizontalTextPosition(2);
        }
        label.setOpaque(isOpaque);
        return label;
    }

    public static JLabel createLabel(String componentKey) {
        return JComponentUtils.createLabel(componentKey, false);
    }

    public static JButton createButton(String componentKey, boolean isOpaque) {
        JButton button = new JButton();
        button.setText(Messages.getString(componentKey));
        button.setIcon(ComponentUtils.getIcon(componentKey));
        String textPosition = Messages.getResource(componentKey + "text.position", "Bottom");
        if ("Top".equalsIgnoreCase(textPosition)) {
            button.setVerticalTextPosition(1);
            button.setHorizontalTextPosition(0);
        }
        if ("Bottom".equalsIgnoreCase(textPosition)) {
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
        }
        if ("Right".equalsIgnoreCase(textPosition)) {
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(4);
        }
        if ("Left".equalsIgnoreCase(textPosition)) {
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(2);
        }
        button.setOpaque(isOpaque);
        return button;
    }

    public static JButton createButton(String componentKey) {
        return JComponentUtils.createButton(componentKey, false);
    }

    public static void disableAllComponents(JComponent component) {
        if (component instanceof JPanel) {
            Component[] comps;
            for (Component comp : comps = component.getComponents()) {
                JComponentUtils.disableAllComponents((JComponent)comp);
            }
        } else {
            component.setEnabled(false);
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.setEditable(false);
            } else if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                if (jButton.getAction() != null) {
                    jButton.getAction().setEnabled(false);
                }
            } else if (component instanceof JToggleButton) {
                JToggleButton jToggleButton = (JToggleButton)component;
                if (jToggleButton.getAction() != null) {
                    jToggleButton.getAction().setEnabled(false);
                } else {
                    jToggleButton.setEnabled(false);
                }
            } else if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setEnabled(false);
            } else if (component instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)component;
                if (jRadioButton.getAction() != null) {
                    jRadioButton.getAction().setEnabled(false);
                } else {
                    jRadioButton.setEnabled(false);
                }
            } else if (component instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)component;
                JComponentUtils.disableAllComponents((JComponent)jScrollPane.getViewport().getView());
            }
        }
    }

    public static void enableAllComponents(JComponent component) {
        if (component == null) {
            return;
        }
        if (component instanceof JPanel) {
            Component[] comps;
            for (Component comp : comps = component.getComponents()) {
                JComponentUtils.enableAllComponents((JComponent)comp);
            }
        } else {
            component.setEnabled(true);
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.setEditable(true);
            } else if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                if (jButton.getAction() != null) {
                    jButton.getAction().setEnabled(true);
                }
            } else if (component instanceof JToggleButton) {
                JToggleButton jToggleButton = (JToggleButton)component;
                if (jToggleButton.getAction() != null) {
                    jToggleButton.getAction().setEnabled(true);
                } else {
                    jToggleButton.setEnabled(true);
                }
            } else if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setEnabled(true);
            } else if (component instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)component;
                JComponentUtils.enableAllComponents((JComponent)jScrollPane.getViewport().getView());
            }
        }
    }

    public static void setKeyListenerToAllComponents(JComponent component, KeyListener keyListener) {
        component.addKeyListener(keyListener);
        if (component instanceof JPanel) {
            Component[] comps;
            for (Component comp : comps = component.getComponents()) {
                JComponentUtils.setKeyListenerToAllComponents((JComponent)comp, keyListener);
            }
        }
    }

    public static void hideAllComponents(JPanel container) {
        Component[] comps;
        for (Component comp : comps = container.getComponents()) {
            comp.setVisible(false);
        }
        Border border = container.getBorder();
        if (border instanceof TitledCurvedBorder) {
            TitledCurvedBorder tcb = (TitledCurvedBorder)border;
            tcb.hide();
        }
    }

    public static void setLookByLicence(JComponent panelToAdd, LicenceTyp lt, JPanel rootPanel, GridBagConstraints gc) {
        if (lt.isVisible()) {
            rootPanel.add((Component)JComponentUtils.setLookByLicence(panelToAdd, lt), gc);
        }
    }

    public static JComponent setLookByLicence(JComponent panel, LicenceTyp lt) {
        if (!lt.isVisible()) {
            return new JPanel();
        }
        if (!lt.isEditable()) {
            JComponentUtils.disableAllComponents(panel);
        }
        return panel;
    }

    public static String cutString(String txt, int maxChars, CutMode mode) {
        if (maxChars == 0) {
            return "";
        }
        if (txt == null || txt.isEmpty()) {
            return "";
        }
        if (txt.length() < maxChars) {
            return txt;
        }
        Object text = "";
        if (mode.equals((Object)CutMode.MODE_START)) {
            text = ".." + txt.substring(txt.length() - maxChars + 2);
        }
        if (mode.equals((Object)CutMode.MODE_END)) {
            text = txt.substring(0, maxChars - 3) + "..";
        }
        if (mode.equals((Object)CutMode.MODE_MIDDLE)) {
            try {
                text = txt.substring(0, maxChars / 2 - 3) + " .. " + txt.substring(txt.length() - maxChars / 2 + 3);
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                text = ".";
            }
        }
        return text;
    }

    public static String displayCNandSerialnumber(Certificate cert) {
        if (cert == null) {
            return "";
        }
        String serialNumber = cert.getSerialNumber().getValueAsString();
        if (serialNumber.length() > 24) {
            serialNumber = JComponentUtils.cutString(serialNumber, 20, CutMode.MODE_MIDDLE);
        }
        LOG.trace("serialnummer: {} -> {}", (Object)cert.getSerialNumber().getValueAsString(), (Object)serialNumber);
        return cert.getSubjectCommonName() + "\n(" + serialNumber + ")";
    }

    public static int getFontWidth(Component component) {
        String testString = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHHIJKLMNOPQRSTUVWXYZ";
        try {
            FontMetrics fm = component.getFontMetrics(component.getFont());
            int width = fm.stringWidth(testString);
            return width / testString.length();
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
            return 6;
        }
    }

    public static int calculateMaxChars(Component component) {
        int durchschnittsWidth = JComponentUtils.getFontWidth(component);
        int componentWidth = component.getWidth();
        return componentWidth / durchschnittsWidth;
    }

    public static void callAction(KeyEvent evt, AbstractSignerAction action) {
        KeyStroke receivedKey;
        String actionName = action.getActionKeyName();
        KeyStroke definedKey = KeyStroke.getKeyStroke(Messages.getResource(actionName + ".key"));
        if (definedKey.equals(receivedKey = KeyStroke.getKeyStrokeForEvent(evt))) {
            action.actionPerformed(null);
        }
    }

    public static enum CutMode {
        MODE_START,
        MODE_END,
        MODE_MIDDLE;

    }
}

