/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GridBagPanel
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private GridBagLayout gridBagLayout;

    public GridBagPanel() {
        this.initGui(null);
    }

    public GridBagPanel(double[] columnWeights) {
        this.initGui(columnWeights);
        this.setFocusable(false);
    }

    private void initGui(double[] columnWeights) {
        this.gridBagLayout = new GridBagLayout();
        if (columnWeights != null) {
            this.gridBagLayout.columnWeights = columnWeights;
        }
        this.setLayout(this.gridBagLayout);
        this.addFocusListener(this);
    }

    public void addComponent(Container container, Component component, int x, int y, int width, int height, double weightx, double weighty, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = 18;
        if (insets != null) {
            gbc.insets = insets;
        }
        this.gridBagLayout.setConstraints(component, gbc);
        container.add(component);
    }

    public void addComponent(Container container, Component component, int x, int y, int width, int height, double weightx, double weighty, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = 18;
        this.gridBagLayout.setConstraints(component, gbc);
        container.add(component);
    }

    public void addComponentWholeNextRow(Container container, Component component) {
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
        this.gridBagLayout.setConstraints(component, wholeNextRow);
        container.add(component);
    }

    public void addComponentWholeNextRow(Container container, Component component, Insets insets) {
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, insets, 0, 0);
        this.gridBagLayout.setConstraints(component, wholeNextRow);
        container.add(component);
    }

    public void addComponentWholeNextRow(Container container, Component component, int startColumn) {
        GridBagConstraints wholeNextRow = new GridBagConstraints(startColumn, -1, 0, 1, 0.0, 0.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
        this.gridBagLayout.setConstraints(component, wholeNextRow);
        container.add(component);
    }

    public void addComponent(Container container, Component component, GridBagConstraints constraints) {
        this.gridBagLayout.setConstraints(component, constraints);
        container.add(component);
    }

    public GridBagLayout getGridBagLayout() {
        return this.gridBagLayout;
    }

    public void setColumnsWeights(double[] colWeights) {
        this.gridBagLayout.columnWeights = colWeights;
        this.revalidate();
    }

    public void setColumnMinWidth(int c, int w) {
        int[] ws = this.gridBagLayout.columnWidths;
        if (ws == null) {
            ws = new int[c + 1];
        } else if (ws.length < c + 1) {
            ws = new int[c + 1];
            System.arraycopy(this.gridBagLayout.columnWidths, 0, ws, 0, this.gridBagLayout.columnWidths.length);
        }
        ws[c] = w;
        this.gridBagLayout.columnWidths = ws;
    }

    public void setRowMinHeight(int r, int h) {
        int[] hs = this.gridBagLayout.rowHeights;
        if (hs == null) {
            hs = new int[r + 1];
        } else if (hs.length < r + 1) {
            hs = new int[r + 1];
            System.arraycopy(this.gridBagLayout.rowHeights, 0, hs, 0, this.gridBagLayout.rowHeights.length);
        }
        hs[r] = h;
        this.gridBagLayout.rowHeights = hs;
    }

    @Override
    public void setBorder(Border border) {
        this.setFocusable(border != null);
        super.setBorder(border);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }
}

