/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DescriptionPanel
extends JPanel {
    private static final long serialVersionUID = -8190504052599840048L;
    private JLabel header;
    private JLabel description;

    public DescriptionPanel(String stepDescriptionKey) {
        this.setText(stepDescriptionKey);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)this.header, "North");
        this.add((Component)this.description, "Center");
    }

    private void setText(String stepDescriptionKey) {
        this.header = new HeaderLabel(stepDescriptionKey + ".description");
        this.description = new DescriptionTextLabel(stepDescriptionKey + ".description");
        this.reinitGUI(stepDescriptionKey);
    }

    public JLabel getHeader() {
        return this.header;
    }

    public JLabel getText() {
        return this.description;
    }

    public void reinitGUI(String stepDescriptionKey) {
        this.reinitGUI(stepDescriptionKey, null);
    }

    public void reinitGUI(String stepDescriptionKey, Object ... argument) {
        this.header.setText(Messages.getString(stepDescriptionKey + ".description.header"));
        String s = Messages.getString(stepDescriptionKey + ".description.text");
        String text = s.startsWith("!") ? "" : s;
        this.description.setText(MessageFormat.format(text, argument));
    }

    @Override
    public void requestFocus() {
    }

    public static String removeHTMLTAG(String textHtml, String string) {
        if (textHtml == null) {
            return null;
        }
        textHtml = textHtml.replace(new StringBuilder("<" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("</" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("<" + string + "/>"), new StringBuilder(""));
        return textHtml;
    }

    private static class HeaderLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private CurvedBorder focusCurvedBorder = CurvedBorder.FOCUSED_BORDER;

        public HeaderLabel(String stepDescriptionKey) {
            super(Messages.getString(stepDescriptionKey + ".header"));
            this.setFont(UIManager.getFont("DescriptionHeader.font"));
            this.setOpaque(false);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setBorder(CurvedBorder.EMPTY_BORDER);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    this.repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.hasFocus()) {
                this.focusCurvedBorder.paintBorder(this, g, 0, 0, this.getSize().width, this.getSize().height);
            }
        }
    }
}

