/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateTimeSpinner
extends JSpinner {
    private static final long serialVersionUID = 1L;

    public DateTimeSpinner() {
        this.init();
    }

    private void init() {
        SpinnerDateModel2 spinnerModel = new SpinnerDateModel2(new SpinnerDateModel(), 11);
        this.setModel(spinnerModel);
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    static class SpinnerDateModel2
    extends SpinnerDateModel
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private final SpinnerDateModel calendarMasterModel;
        private transient boolean arrowMode = false;

        public SpinnerDateModel2(SpinnerDateModel m, int calendarField) {
            this.calendarMasterModel = m;
            this.calendarMasterModel.addChangeListener(this);
            this.setCalendarField(calendarField);
        }

        @Override
        public Object getNextValue() {
            this.arrowMode = true;
            this.calendarMasterModel.setCalendarField(this.getCalendarField());
            return this.calendarMasterModel.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            this.arrowMode = true;
            this.calendarMasterModel.setCalendarField(this.getCalendarField());
            return this.calendarMasterModel.getPreviousValue();
        }

        @Override
        public Object getValue() {
            return this.calendarMasterModel.getValue();
        }

        @Override
        public void setValue(Object value) {
            if (this.arrowMode) {
                this.calendarMasterModel.setValue(value);
                this.arrowMode = false;
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)value);
                int calendarField = this.getCalendarField();
                int fieldValue = cal.get(calendarField);
                cal.setTime(this.calendarMasterModel.getDate());
                if (cal.get(calendarField) != fieldValue) {
                    cal.set(calendarField, fieldValue);
                    this.calendarMasterModel.setValue(cal.getTime());
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireStateChanged();
        }
    }
}

