/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.gui.SignerTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class CurvedBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    public static final Color FOCUSED_COLOR = SignerTheme.BOREUM_PETROL;
    public static final Color DEFAULT_COLOR = SignerTheme.GRAY_3;
    public static final Color ACTIVE_COLOR = SignerTheme.SIGNER_BLUE_1;
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Color BOREUM_PETROL = SignerTheme.BOREUM_PETROL;
    private Color borderColor = DEFAULT_COLOR;
    private int insets = 5;
    public static final int CORNER_RADIUS = 8;
    private int cornerRadius = 8;
    public static final int LINE_EMPTY = 0;
    public static final int LINE_FOCUSED = 2;
    public static final int LINE_ACTIVE = 3;
    public static final int LINE = 1;
    private int lineWidth = 1;
    public static final CurvedBorder EMPTY_BORDER = CurvedBorder.createEmpty();
    public static final CurvedBorder WHITE_BORDER = CurvedBorder.createWhite2();
    public static final CurvedBorder FOCUSED_BORDER = CurvedBorder.createFocused();
    public static final CurvedBorder FOCUSED_FIELD_BORDER = CurvedBorder.createFocusedForField();
    public static final CurvedBorder DEFAULT_BORDER = CurvedBorder.createDefault();
    public static final CurvedBorder ACTIVE_BORDER = CurvedBorder.createActive();
    public static final CurvedBorder ACTIVE_BORDER_THIN = CurvedBorder.createActiveThin();
    public static final CurvedBorder BORDER_WHITE = CurvedBorder.createBorderWhite();
    public static final CurvedBorder BORDER_PROCESS_FOCUSED = CurvedBorder.createProcessBorderWhite();
    public static final CurvedBorder BORDER_PROCESS_FOCUSLESS = CurvedBorder.createProcessBorderFocusless();
    public static final CurvedBorder BORDER_BLUE = CurvedBorder.createCurvedBorder(SignerTheme.SIGNER_BLUE_2);

    private static CurvedBorder createFocusedForField() {
        return new CurvedBorder(2, 0, FOCUSED_COLOR);
    }

    private static CurvedBorder createBorderWhite() {
        return new CurvedBorder(2, 8, Color.WHITE);
    }

    private static CurvedBorder createProcessBorderWhite() {
        return new CurvedBorder(1, 0, Color.WHITE);
    }

    private static CurvedBorder createProcessBorderFocusless() {
        return new CurvedBorder(2, 0, Color.WHITE);
    }

    public CurvedBorder(Color borderColor) {
        this.borderColor = borderColor;
    }

    public static CurvedBorder createCurvedBorder(Color borderColor) {
        return new CurvedBorder(borderColor);
    }

    public CurvedBorder(int lineWidth, int cornerRadius, Color borderColor) {
        this.lineWidth = lineWidth;
        this.cornerRadius = cornerRadius;
        this.borderColor = borderColor;
    }

    public static CurvedBorder createEmpty() {
        return new CurvedBorder(2, 8, COLOR_TRANSPARENT);
    }

    public static CurvedBorder createWhite2() {
        return new CurvedBorder(2, 0, Color.WHITE);
    }

    public static CurvedBorder createDefault() {
        return new CurvedBorder(1, 8, DEFAULT_COLOR);
    }

    public static CurvedBorder createActive() {
        return new CurvedBorder(3, 8, ACTIVE_COLOR);
    }

    public static CurvedBorder createActiveThin() {
        return new CurvedBorder(2, 8, ACTIVE_COLOR);
    }

    public static CurvedBorder createFocused() {
        return new CurvedBorder(2, 8, FOCUSED_COLOR);
    }

    public void setLineWidth(int width) {
        if (width >= 0 && width < 10) {
            this.lineWidth = width;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.lineWidth > 0) {
            g.setColor(this.borderColor);
            GeneralPath p = new GeneralPath(0);
            RoundRectangle2D.Float roundRec = new RoundRectangle2D.Float();
            ((RoundRectangle2D)roundRec).setRoundRect(x, y, w, h, this.cornerRadius, this.cornerRadius);
            p.append(roundRec, false);
            ((RoundRectangle2D)roundRec).setRoundRect((double)x + (double)this.lineWidth, (double)y + (double)this.lineWidth, (double)w - (double)(this.lineWidth * 2), (double)h - (double)(this.lineWidth * 2), (double)this.cornerRadius - 2.0, (double)this.cornerRadius - 2.0);
            p.append(roundRec, true);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fill(p);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.insets, this.insets, this.insets, this.insets);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.bottom = i.top = this.insets;
        i.right = i.top;
        i.left = i.top;
        return i;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getSinkLevel() {
        return this.insets;
    }

    public void setInsets(int newInsets) {
        this.insets = newInsets;
    }
}

