/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view.component;

import de.bos_bremen.ecard.client.Utils;
import java.io.File;

public class ComputeDigest {
    private ComputeDigest() {
        throw new IllegalStateException("Utility class");
    }

    public static String computeDigest(File file) {
        byte[] digest = Utils.createSHA256Hash(file);
        return digest != null ? ComputeDigest.convertToHex(digest) : "";
    }

    public static String computeDigest(String fileName) {
        return fileName != null ? ComputeDigest.computeDigest(new File(fileName)) : "";
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buf.toString();
    }
}

