/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.view;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JTable;

public class OrderedFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final Vector<Component> order = new Vector();

    public void setOrder(Vector<Component> order) {
        this.order.clear();
        if (order != null) {
            this.order.addAll(order);
        }
        if (order != null) {
            for (Component comp : order) {
                comp.setFocusTraversalKeys(0, new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 0))));
                comp.setFocusTraversalKeys(1, new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 64))));
            }
        }
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        return this.getComponentAfter(focusCycleRoot, aComponent, this.order.size());
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent, int counter) {
        if (counter <= 0) {
            return null;
        }
        if (!this.order.isEmpty()) {
            JTable table;
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            Component newComponent = this.order.get(idx);
            if (!(newComponent.isEnabled() && newComponent.isFocusable() && newComponent.isVisible())) {
                return this.getComponentAfter(focusCycleRoot, newComponent, counter - 1);
            }
            if (newComponent instanceof JTable && (table = (JTable)newComponent).getModel().getRowCount() == 0) {
                return this.getComponentAfter(focusCycleRoot, newComponent, counter - 1);
            }
            return newComponent;
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        return this.getComponentBefore(focusCycleRoot, aComponent, this.order.size());
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent, int counter) {
        if (counter <= 0) {
            return null;
        }
        if (!this.order.isEmpty()) {
            JTable table;
            Component newComponent;
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            if (!((newComponent = this.order.get(idx)).isEnabled() && newComponent.isFocusable() && newComponent.isVisible())) {
                return this.getComponentBefore(focusCycleRoot, newComponent, counter - 1);
            }
            if (newComponent instanceof JTable && (table = (JTable)newComponent).getModel().getRowCount() == 0) {
                return this.getComponentBefore(focusCycleRoot, newComponent, counter - 1);
            }
            return newComponent;
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        if (!this.order.isEmpty()) {
            JTable table;
            Component newComponent = this.order.lastElement();
            if (!(newComponent.isEnabled() && newComponent.isFocusable() && newComponent.isVisible())) {
                return this.getComponentBefore(focusCycleRoot, newComponent);
            }
            if (newComponent instanceof JTable && (table = (JTable)newComponent).getModel().getRowCount() == 0) {
                return this.getComponentBefore(focusCycleRoot, newComponent);
            }
            return newComponent;
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        if (!this.order.isEmpty()) {
            JTable table;
            Component newComponent = this.order.get(0);
            if (!(newComponent.isEnabled() && newComponent.isFocusable() && newComponent.isVisible())) {
                return this.getComponentAfter(focusCycleRoot, newComponent);
            }
            if (newComponent instanceof JTable && (table = (JTable)newComponent).getModel().getRowCount() == 0) {
                return this.getComponentAfter(focusCycleRoot, newComponent);
            }
            return newComponent;
        }
        return null;
    }
}

