/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.control.step.ProgressEvent;
import de.bos_bremen.ecard.client.control.step.ProgressListener;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.step.SubseqentProcessCellRenderer;
import de.bos_bremen.ecard.client.gui.view.OrderedFocusTraversalPolicy;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableModelI;
import de.bos_bremen.ecard.client.gui.view.component.table.workingresult.WorkingResultTableMouseListenerFactory;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.ConfigListener;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessSubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WorkingStepView
extends JPanel
implements StepChangedListener,
ProgressListener,
ConfigListener,
PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(WorkingStepView.class);
    private static final long serialVersionUID = 7824048116595091494L;
    protected transient WorkingStep lastStep;
    protected JComboBox<SubsequentProcess> subsequentProcessCombobox;
    protected DescriptionPanel descriptionPanel;
    protected transient WorkingResultTableModelI resultsTableModel;
    protected transient WorkingResultTableI resultsTable;
    protected transient OrderedFocusTraversalPolicy focusTraversalPolicy;
    protected JPanel subsequentProcessPanel;
    protected JPanel stepContentPanel;
    private IconButton runSubsequentProcessButton;
    private final boolean showResultTable;

    protected WorkingStepView(WorkingStep workingStep) {
        this(workingStep, null);
    }

    protected WorkingStepView(WorkingStep workingStep, JPanel content, boolean showResultTable) {
        this.showResultTable = showResultTable;
        this.lastStep = workingStep;
        this.stepContentPanel = content != null ? new JPanel() : this;
        this.initGUI(this.stepContentPanel);
        this.lastStep.addStateChangeListener(this);
        this.lastStep.addProgressListener(this);
        Config.getInstance().addListener(this);
        LocaleChanger.getInstance().addObserver(this);
    }

    protected WorkingStepView(WorkingStep workingStep, JPanel content) {
        this(workingStep, content, true);
    }

    public List<WorkingResult> returnWorkingResultList() {
        return this.lastStep.getWorkingResults();
    }

    public boolean startProcess() {
        LOG.trace("");
        boolean successful = true;
        SubsequentProcess process = null;
        Object obj = this.subsequentProcessCombobox.getSelectedItem();
        if (obj instanceof SubsequentProcess) {
            ProcessSubsequentProcess processSubsequentProcess;
            SubsequentProcess subsequentProcess = (SubsequentProcess)obj;
            if (obj instanceof ProcessSubsequentProcess && (processSubsequentProcess = (ProcessSubsequentProcess)obj).getProcessName().equals(RootProcessName.getInstance())) {
                LOG.trace("none subsequent Prozess");
            } else {
                process = subsequentProcess;
                LOG.debug("subsequent Prozess : {}", (Object)process);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        LOG.info("FrameworkState : {} -> processing", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.processing);
        this.lastStep.run(process);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.runSubsequentProcessButton.setEnabled(false);
        LOG.trace("done");
        return successful;
    }

    protected void initGUI(JPanel contentPanel) {
        contentPanel.setLayout(new BorderLayout());
        this.descriptionPanel = new DescriptionPanel("step." + this.lastStep.getStepName().toString());
        this.subsequentProcessPanel = new JPanel();
        this.subsequentProcessPanel.setLayout(new GridBagLayout());
        contentPanel.add((Component)this.descriptionPanel, "First");
        this.runSubsequentProcessButton = new IconButton("action.run.process");
        this.runSubsequentProcessButton.setEnabled(false);
        this.runSubsequentProcessButton.addActionListener(arg0 -> this.lastStep.callSubsequentProcess((SubsequentProcess)this.subsequentProcessCombobox.getSelectedItem()));
        AccessibleJLabel subsequentProcessLabel = new AccessibleJLabel(Messages.getString("step." + this.lastStep.getStepName().toString() + ".usesubsequentprocess"));
        this.subsequentProcessCombobox = new JComboBox();
        subsequentProcessLabel.setLabelFor(this.subsequentProcessCombobox);
        this.initSubsequentCombo();
        LicenceTyp subsequentProcessLT = Document.getInstance().getProductFunctions().enableGeneralActionsSettingsSubsequentProcess();
        if (subsequentProcessLT.isVisible() && Document.getInstance().isSaveConfig()) {
            if (!subsequentProcessLT.isEditable()) {
                this.subsequentProcessCombobox.setEnabled(false);
                this.runSubsequentProcessButton.setEnabled(false);
            }
            Insets insets = new Insets(0, 0, 0, 0);
            this.subsequentProcessPanel.add((Component)subsequentProcessLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, insets, 0, 0));
            this.subsequentProcessPanel.add(this.subsequentProcessCombobox, new GridBagConstraints(0, 1, 4, 1, 4.0, 1.0, 17, 2, insets, 0, 0));
            this.subsequentProcessPanel.add((Component)this.runSubsequentProcessButton, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0));
        }
        this.subsequentProcessCombobox.addItemListener(e -> {
            Object obj = this.subsequentProcessCombobox.getSelectedItem();
            if (obj instanceof SubsequentProcess) {
                ProcessSubsequentProcess processSubsequentProcess;
                SubsequentProcess subsequentProcess = (SubsequentProcess)obj;
                if (obj instanceof ProcessSubsequentProcess && (processSubsequentProcess = (ProcessSubsequentProcess)obj).getProcessName().equals(RootProcessName.getInstance())) {
                    this.runSubsequentProcessButton.setEnabled(false);
                } else {
                    this.runSubsequentProcessButton.setEnabled(Document.getInstance().getProductFunctions().enableGeneralActionsSettingsSubsequentProcess().isEditable() && !this.lastStep.workingListContainError());
                }
                this.lastStep.setSubsequentProcess(subsequentProcess);
            }
        });
        contentPanel.add((Component)this.subsequentProcessPanel, "South");
        this.resultsTable = WorkingResultTableFactory.createWorkingResultTable(this.lastStep.getParent());
        this.resultsTableModel = (WorkingResultTableModelI)this.resultsTable.getModel();
        this.resultsTable.setModel(this.resultsTableModel);
        ((JTable)((Object)this.resultsTable)).addMouseListener(WorkingResultTableMouseListenerFactory.createWorkingResultTableMouseListener(this, this.lastStep.getParent().getProcessName()));
        JScrollPane scrollPane = new JScrollPane((JTable)((Object)this.resultsTable));
        String mnemonic = Messages.getResource("view.step.selectfiles.list.header.mnemonic");
        KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        scrollPane.getInputMap(2).put(ks, "selectTable");
        scrollPane.getActionMap().put("selectTable", new SetFocusOnTableAction());
        if (this.showResultTable) {
            contentPanel.add((Component)scrollPane, "Center");
        }
        this.stateChanged(null);
    }

    private void initSubsequentCombo() {
        SubsequentProcess defaultSubsequentProcess;
        this.subsequentProcessCombobox.removeAllItems();
        this.subsequentProcessCombobox.setRenderer(new SubseqentProcessCellRenderer());
        List<SubsequentProcess> subsequentProcessList = Config.getInstance().getSubsequentProcessList();
        if (subsequentProcessList != null) {
            for (SubsequentProcess process : subsequentProcessList) {
                ProcessSubsequentProcess processSubsequentProcess;
                if (process instanceof ProcessSubsequentProcess && (processSubsequentProcess = (ProcessSubsequentProcess)process).getProcessName().equals(this.lastStep.getParent().getProcessName())) continue;
                this.subsequentProcessCombobox.addItem(process);
            }
        }
        if ((defaultSubsequentProcess = this.lastStep.getDefaultSubsequentProcess()) != null) {
            this.subsequentProcessCombobox.setSelectedItem(defaultSubsequentProcess);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        LOG.trace("");
        this.updateWorkingResultTable();
        this.subsequentProcessCombobox.setSelectedItem(this.getWorkingStep().getSubsequentProcess());
    }

    private void updateWorkingResultTable() {
        SwingUtilities.invokeLater(() -> {
            List<WorkingResult> workingResults = this.lastStep.getWorkingResults();
            this.resultsTableModel.setDataVector(workingResults.toArray(new WorkingResult[0]));
            this.resultsTable.setColumnWidth();
        });
    }

    @Override
    public void handleProgressEvent(ProgressEvent arg0) {
        this.updateWorkingResultTable();
    }

    @Override
    public void configChanged() {
        this.initSubsequentCombo();
    }

    public void refreshTable(int row) {
        WorkingResultTableModelI model = (WorkingResultTableModelI)this.resultsTable.getModel();
        Vector data = (Vector)model.getDataVector().get(row);
        WorkingResult result = (WorkingResult)data.get(0);
        if (result.getProcessFile() != null) {
            try {
                result.getProcessFile().setSeen(true);
            }
            catch (SignerException e) {
                Document.getInstance().reportError(e, false, new Object[0]);
            }
        }
        this.stateChanged(null);
    }

    @Override
    public void setActive(boolean active) {
        LOG.trace("");
        if (active) {
            SwingUtilities.invokeLater(() -> {
                Component comp;
                if (this.focusTraversalPolicy != null && (comp = this.focusTraversalPolicy.getDefaultComponent(this)) != null) {
                    comp.requestFocusInWindow();
                }
            });
        }
    }

    public WorkingStep getWorkingStep() {
        return this.lastStep;
    }

    private class SetFocusOnTableAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SetFocusOnTableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ((JTable)((Object)WorkingStepView.this.resultsTable)).requestFocusInWindow();
        }
    }
}

