/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.list.renderer.AliasObjectListCellRenderer;
import de.bos_bremen.ecard.client.model.AliasObject;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChooseCertificatesDialog
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(ChooseCertificatesDialog.class);
    private JLabel instructionLabel;
    private JButton ok;
    private JButton cancel;
    private JScrollPane scrollPane;
    private JList list;
    private transient KeyProvider shownKeyProvider;
    private String selectedAlias;
    private String keyUsage;

    public ChooseCertificatesDialog(String keyUsage) {
        this((JFrame)null, keyUsage);
    }

    public ChooseCertificatesDialog(JFrame root, String keyUsage) {
        super((Frame)root, true);
        this.keyUsage = keyUsage;
        this.setIconImage(ComponentUtils.getImage("application"));
        this.setTitle(Messages.getString("choose.alias." + keyUsage + ".dialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChooseCertificatesDialog.this.resetAndHide();
            }
        });
        this.initGui();
        this.layoutGui();
        Dimension parentMinSize = Document.getInstance().getFrame().getMinimumSize();
        this.setMinimumSize(GUIUtils.createRelativeToParent(parentMinSize, 0.7, 0.3));
        this.setPreferredSize(GUIUtils.createRelativeToParent(parentMinSize, 0.7, 0.3));
        this.pack();
    }

    private void initGui() {
        this.instructionLabel = new JLabel(Messages.getString("choose.alias." + this.keyUsage + ".dialog.text"));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isLeftClicked;
                boolean bl = isLeftClicked = e.getButton() == 1;
                if (isLeftClicked && e.getClickCount() == 2) {
                    ChooseCertificatesDialog.this.ok.doClick();
                }
            }
        });
        this.list.setCellRenderer(new AliasObjectListCellRenderer());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.list);
        this.ok = new JButton(Messages.getString("choose.alias." + this.keyUsage + ".dialog.ok.text"));
        this.ok.setFocusable(true);
        this.ok.setFocusPainted(true);
        CancelAction cancelAction = new CancelAction();
        this.cancel = new JButton(Messages.getString("choose.alias." + this.keyUsage + ".dialog.cancel.text"));
        this.cancel.addActionListener(cancelAction);
        this.cancel.setFocusable(true);
        this.cancel.setFocusPainted(true);
        ComponentInputMap keyMap = new ComponentInputMap(this.cancel);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("cancelAction", cancelAction);
        SwingUtilities.replaceUIActionMap(this.cancel, actionMap);
        SwingUtilities.replaceUIInputMap(this.cancel, 2, keyMap);
        keyMap = new ComponentInputMap(this.cancel);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(32, 0), "cancelAction");
        SwingUtilities.replaceUIInputMap(this.cancel, 0, keyMap);
    }

    private void layoutGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(15, 5, 0, 5);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.instructionLabel, gbc);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.scrollPane, gbc);
        gbc.insets = new Insets(15, 5, 5, 5);
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 14;
        this.add((Component)this.ok, gbc);
        gbc.insets = new Insets(15, 10, 5, 5);
        gbc.gridx = 1;
        gbc.anchor = 16;
        this.add((Component)this.cancel, gbc);
    }

    private void updateList() {
        LOG.debug("Updating list...");
        Vector<AliasObject> listData = new Vector<AliasObject>();
        if (this.shownKeyProvider != null) {
            List<String> aliasList = this.shownKeyProvider.getAllAliases();
            for (String alias : aliasList) {
                listData.add(new AliasObject(alias, this.shownKeyProvider.getUsageName(alias)));
            }
        }
        this.list.setListData(listData);
        if (!listData.isEmpty()) {
            this.list.setSelectedIndex(0);
            this.selectedAlias = ((AliasObject)listData.get(0)).getAlias();
        }
        LOG.debug("List updated.");
    }

    public void setKeyProvider(KeyProvider keyProvider) {
        LOG.debug("Setting keyProvider...");
        this.shownKeyProvider = keyProvider;
        this.updateList();
        LOG.debug("KeyProvider set.");
    }

    public void addOkAction(Action action) {
        this.ok.addActionListener(action);
        ComponentInputMap keyMap = new ComponentInputMap(this.ok);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(10, 0), "okAction");
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("okAction", action);
        SwingUtilities.replaceUIActionMap(this.ok, actionMap);
        SwingUtilities.replaceUIInputMap(this.ok, 2, keyMap);
        keyMap = new ComponentInputMap(this.ok);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(32, 0), "okAction");
        SwingUtilities.replaceUIInputMap(this.ok, 0, keyMap);
    }

    public KeyProvider getCurrentlySelectedKeyProvider() {
        return this.shownKeyProvider;
    }

    private void resetAndHide() {
        this.setKeyProvider(null);
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.shownKeyProvider != null) {
            this.selectedAlias = ((AliasObject)this.list.getSelectedValue()).getAlias();
            LOG.debug("Selected alias changed to {}", (Object)this.selectedAlias);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        SwingUtilities.invokeLater(() -> this.ok.requestFocusInWindow());
    }

    public String getSelectedAlias() {
        return this.selectedAlias;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChooseCertificatesDialog.this.resetAndHide();
        }
    }
}

