/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.step;

import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.view.component.label.CurvedLabel;
import de.bos_bremen.ecard.client.gui.view.component.table.CertificatesTable;
import de.bos_bremen.ecard.client.gui.view.component.table.ViewKeyProviderAction;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class CertificatesList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private CertificatesTable certTable;
    private final ArrayList<KeyProvider> keyProviders = new ArrayList();
    private String columnHeaderText;

    public CertificatesList(List<KeyProvider> keyProviders, String columnHeaderText) {
        this.columnHeaderText = columnHeaderText;
        this.initGui();
        this.layoutGui();
        this.setKeyProviders(keyProviders);
    }

    private void initGui() {
        this.certTable = new CertificatesTable();
        this.certTable.setFocusable(true);
        CurvedLabel columnHeaderLabel = new CurvedLabel(this.columnHeaderText, 0);
        columnHeaderLabel.setOpaque(true);
        columnHeaderLabel.setBackground(SignerTheme.SIGNER_WHITE_2);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.certTable);
        this.scrollPane.setVerticalScrollBarPolicy(22);
    }

    private void layoutGui() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateList() {
        Object[][] data = new Object[this.keyProviders.size()][2];
        for (int i = 0; i < this.keyProviders.size(); ++i) {
            KeyProvider keyProvider = this.keyProviders.get(i);
            data[i][0] = keyProvider;
            data[i][1] = new ViewKeyProviderAction(keyProvider);
        }
        this.certTable.setListData(data);
    }

    public void setKeyProviders(List<KeyProvider> keyProviders) {
        this.keyProviders.clear();
        if (keyProviders != null) {
            this.keyProviders.addAll(keyProviders);
        }
        this.updateList();
    }

    public void addKeyProvider(KeyProvider keyProvider) {
        if (keyProvider == null) {
            return;
        }
        this.keyProviders.add(keyProvider);
        this.updateList();
    }

    public List<KeyProvider> getKeyProviders() {
        return new ArrayList<KeyProvider>(this.keyProviders);
    }

    public List<KeyProvider> getSelectedKeyProviders() {
        int[] selectedIndices = this.certTable.getSelectedIndices();
        ArrayList<KeyProvider> selectedKeyProviders = new ArrayList<KeyProvider>();
        for (int i = 0; i < selectedIndices.length; ++i) {
            selectedKeyProviders.add(this.keyProviders.get(selectedIndices[i]));
        }
        return selectedKeyProviders;
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.certTable.getSelectionModel().addListSelectionListener(lsl);
    }

    public void removeListSelectionListener(ListSelectionListener lsl) {
        this.certTable.getSelectionModel().removeListSelectionListener(lsl);
    }

    public boolean isSelectionModelTheSame(ListSelectionModel lsm) {
        if (this.certTable == null || lsm == null) {
            return false;
        }
        return lsm == this.certTable.getSelectionModel();
    }

    public CertificatesTable getCertTable() {
        return this.certTable;
    }
}

